/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.triggers;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.TriggersService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.model.Trigger;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;

public class CreateTriggerRequestExecutor
extends RequestExecutor<Trigger> {
    private final TriggersService triggersService;
    private final Trigger trigger;

    public CreateTriggerRequestExecutor(TriggersService triggersService, Trigger trigger) {
        this.triggersService = triggersService;
        this.trigger = trigger;
    }

    @Override
    public Trigger execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (Trigger)super.execute();
    }

    @Override
    public void execute(CloudCallback<Trigger> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<Trigger> prepareCall() {
        return this.triggersService.create(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.trigger.getName() != null, "Cannot create trigger - specify name");
        SDKPreconditions.checkState(this.trigger.getType() != null, "Cannot create trigger - specify type");
        SDKPreconditions.checkState(this.trigger.getContext() != null, "Cannot create trigger - specify context");
        SDKPreconditions.checkState(this.trigger.getContext().getTrackingId() != null, "Cannot create trigger - specify tracking ID");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", this.trigger.getName());
        params.put("type", this.trigger.getType().name());
        params.put("context.trackingId", this.trigger.getContext().getTrackingId());
        if (this.trigger.getContext().getProximity() != null) {
            params.put("context.proximity", this.trigger.getContext().getProximity().name());
        }
        if (this.trigger.getContext().getSourceId() != null) {
            params.put("context.sourceId", this.trigger.getContext().getSourceId());
        }
        return params;
    }
}

