/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor;

import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.response.CloudError;
import com.kontakt.sdk.android.cloud.response.CloudHeaders;
import com.kontakt.sdk.android.cloud.util.ErrorUtils;
import java.util.HashMap;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class CloudCallbackWrapper<T>
implements Callback<T> {
    private final CloudCallback<T> callback;

    public CloudCallbackWrapper(CloudCallback<T> callback) {
        this.callback = callback;
    }

    public void onResponse(Call<T> call, Response<T> response) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String key : response.headers().names()) {
            headers.put(key, response.headers().get(key));
        }
        if (response.isSuccessful()) {
            Object body = response.body();
            this.callback.onSuccess(body, CloudHeaders.of(headers));
        } else {
            CloudError cloudError = ErrorUtils.parseError(response);
            this.callback.onError(cloudError);
        }
    }

    public void onFailure(Call<T> call, Throwable t) {
        CloudError error = new CloudError(null, -1, t.getLocalizedMessage());
        this.callback.onError(error);
    }
}

