/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.util;

import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.Collection;

public class ScanContextUtils {
    public static ScanContext cloneWithNewSpaces(ScanContext oldContext, Collection<IBeaconRegion> regions, Collection<IEddystoneNamespace> namespaces) {
        SDKPreconditions.checkNotNull(oldContext);
        SDKPreconditions.checkNotNull(regions);
        SDKPreconditions.checkNotNull(namespaces);
        return ScanContextUtils.cloneBuilder(oldContext).setIBeaconRegions(regions).setEddystoneNamespaces(namespaces).build();
    }

    public static ScanContext.Builder cloneBuilder(ScanContext scanContext) {
        return new ScanContext.Builder().setScanMode(scanContext.getScanMode()).setScanPeriod(scanContext.getScanPeriod()).setForceScanConfiguration(scanContext.getForceScanConfiguration()).setActivityCheckConfiguration(scanContext.getActivityCheckConfiguration()).setDevicesUpdateCallbackInterval(scanContext.getDevicesUpdateCallbackInterval()).setRssiCalculator(scanContext.getRssiCalculator()).setObservedProfiles(scanContext.getObservedProfiles()).setIBeaconRegions(scanContext.getIBeaconRegions()).setIBeaconFilters(scanContext.getIBeaconFilters()).setEddystoneNamespaces(scanContext.getEddystoneNamespaces()).setEddystoneFilters(scanContext.getEddystoneFilters()).setRequiredEddystoneFrameTypes(scanContext.getEddystoneFrameTypes());
    }
}

