/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.util;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.content.Context;
import android.os.Build;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.lang.reflect.Method;

public final class BluetoothUtils {
    private static final String TAG = BluetoothUtils.class.getSimpleName();

    private BluetoothUtils() {
    }

    public static boolean isBluetoothEnabled() {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        return bluetoothAdapter != null && bluetoothAdapter.isEnabled();
    }

    public static boolean isBluetoothLeSupported(Context context) {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        SDKPreconditions.checkNotNull(context, "Context is null");
        return context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    public static BluetoothDevice getBluetoothDevice(String address) {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            return null;
        }
        return bluetoothAdapter.getRemoteDevice(address);
    }

    public static boolean refreshGattServer(BluetoothGatt gattServer) {
        if (gattServer == null) {
            Logger.e("BluetoothGatt is null. Cannot refresh");
            return false;
        }
        try {
            Method method = gattServer.getClass().getMethod("refresh", new Class[0]);
            if (method != null) {
                return (Boolean)method.invoke((Object)gattServer, new Object[0]);
            }
        }
        catch (Exception e) {
            Logger.e(TAG + "Error when refreshing gatt", e);
        }
        return false;
    }
}

