/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanPeriod;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.service.BleScanCallback;
import com.kontakt.sdk.android.ble.service.DefaultBluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.common.KontaktSDK;
import com.kontakt.sdk.android.common.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

abstract class MonitorCallback
implements BleScanCallback,
DiscoveryContract {
    final BluetoothDeviceDiscoverer bluetoothDeviceDiscoverer;
    private final Handler handler = new Handler();
    private final Map<Integer, InternalProximityListener> monitoringListenerMap = new ConcurrentHashMap<Integer, InternalProximityListener>();
    private final ActivityCheckConfiguration activityCheckConfiguration;
    private final ScanPeriod scanPeriod;
    private final Runnable periodicActivityCheckRunnable = new Runnable(){

        @Override
        public void run() {
            MonitorCallback.this.evictInactiveDevices(System.currentTimeMillis());
        }
    };

    MonitorCallback(ScanContext scanContext, Collection<InternalProximityListener> listeners) {
        this.bluetoothDeviceDiscoverer = new DefaultBluetoothDeviceDiscoverer(scanContext, this);
        this.activityCheckConfiguration = scanContext.getActivityCheckConfiguration();
        this.scanPeriod = scanContext.getScanPeriod();
        this.addRegisteredListeners(listeners);
    }

    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (!this.isAnyListenerRegistered() && KontaktSDK.isInitialized()) {
            return;
        }
        if (device == null) {
            Logger.d("Remote device discovered but is null");
            return;
        }
        this.performDiscovery(device, rssi, scanRecord);
    }

    private void performDiscovery(final BluetoothDevice device, final int rssi, final byte[] scanRecord) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                MonitorCallback.this.bluetoothDeviceDiscoverer.performDiscovery(device, rssi, scanRecord);
                Logger.d(String.format("Device discovered %s", device.toString()));
            }
        });
    }

    @Override
    public Collection<InternalProximityListener> getMonitoringListeners() {
        return Collections.unmodifiableCollection(new ArrayList<InternalProximityListener>(this.monitoringListenerMap.values()));
    }

    @Override
    public void addListener(InternalProximityListener proximityListener) {
        int hashCode = System.identityHashCode(proximityListener);
        InternalProximityListener insertion = this.monitoringListenerMap.put(hashCode, proximityListener);
        if (insertion == null) {
            Logger.d("MonitoringListener registered: " + hashCode);
        }
    }

    @Override
    public void removeListener(InternalProximityListener proximityListener) {
        int hashCode = System.identityHashCode(proximityListener);
        InternalProximityListener deletion = this.monitoringListenerMap.remove(hashCode);
        if (deletion != null) {
            Logger.d("MonitoringListener unregistered: " + hashCode);
        }
    }

    @Override
    public void onMonitorCycleStart() {
        if (this.scanPeriod != ScanPeriod.RANGING) {
            for (final InternalProximityListener proximityListener : this.monitoringListenerMap.values()) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        proximityListener.onMonitoringCycleStart();
                    }
                });
            }
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                MonitorCallback.this.startPeriodicInactivityCheck();
            }
        });
    }

    @Override
    public void onMonitorCycleStop() {
        if (this.scanPeriod != ScanPeriod.RANGING) {
            for (final InternalProximityListener proximityListener : this.monitoringListenerMap.values()) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        proximityListener.onMonitoringCycleStop();
                    }
                });
            }
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                MonitorCallback.this.stopPeriodicInactivityCheck();
            }
        });
    }

    @Override
    public void onEvent(BluetoothDeviceEvent event) {
        for (InternalProximityListener proximityListener : this.monitoringListenerMap.values()) {
            proximityListener.onEvent(event);
        }
    }

    void startPeriodicInactivityCheck() {
        if (this.activityCheckConfiguration == ActivityCheckConfiguration.DISABLED) {
            return;
        }
        long checkPeriod = this.activityCheckConfiguration.getCheckPeriod();
        this.handler.postDelayed(this.periodicActivityCheckRunnable, checkPeriod);
    }

    void stopPeriodicInactivityCheck() {
        if (this.activityCheckConfiguration == ActivityCheckConfiguration.DISABLED) {
            return;
        }
        this.handler.removeCallbacksAndMessages(null);
    }

    void evictInactiveDevices(long currentTimeMillis) {
        this.bluetoothDeviceDiscoverer.evictInactiveDevices(currentTimeMillis);
        this.startPeriodicInactivityCheck();
    }

    private void addRegisteredListeners(Collection<InternalProximityListener> listeners) {
        for (InternalProximityListener proximityListener : listeners) {
            this.addListener(proximityListener);
        }
    }

    private boolean isAnyListenerRegistered() {
        return !this.monitoringListenerMap.isEmpty();
    }

    @Override
    public void close() {
        this.bluetoothDeviceDiscoverer.disable();
        this.monitoringListenerMap.clear();
        this.handler.removeCallbacksAndMessages(null);
    }
}

