/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.bluetooth.BluetoothDevice;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneDiscoverer;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconDiscoverer;
import com.kontakt.sdk.android.ble.discovery.secure_profile.SecureProfileDiscoverer;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import java.util.ArrayList;
import java.util.Collection;

final class DefaultBluetoothDeviceDiscoverer
implements BluetoothDeviceDiscoverer {
    private final Collection<BluetoothDeviceDiscoverer> discoverers = new ArrayList<BluetoothDeviceDiscoverer>();

    DefaultBluetoothDeviceDiscoverer(ScanContext scanContext, DiscoveryContract discoveryContract) {
        if (scanContext.getObservedProfiles().contains((Object)DeviceProfile.IBEACON)) {
            this.discoverers.add(new IBeaconDiscoverer(scanContext, discoveryContract));
        }
        if (scanContext.getObservedProfiles().contains((Object)DeviceProfile.EDDYSTONE)) {
            this.discoverers.add(new EddystoneDiscoverer(scanContext, discoveryContract));
        }
        if (scanContext.getObservedProfiles().contains((Object)DeviceProfile.KONTAKT_SECURE)) {
            this.discoverers.add(new SecureProfileDiscoverer(scanContext, discoveryContract));
        }
    }

    @Override
    public boolean performDiscovery(BluetoothDevice bluetoothDevice, int rssi, byte[] scanResult) {
        for (BluetoothDeviceDiscoverer discoverer : this.discoverers) {
            if (!discoverer.performDiscovery(bluetoothDevice, rssi, scanResult)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void disable() {
        for (BluetoothDeviceDiscoverer discoverer : this.discoverers) {
            discoverer.disable();
        }
    }

    @Override
    public synchronized void evictInactiveDevices(long currentTimeMillis) {
        for (BluetoothDeviceDiscoverer discoverer : this.discoverers) {
            discoverer.evictInactiveDevices(currentTimeMillis);
        }
    }
}

