/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.monitoring;

import com.kontakt.sdk.android.ble.configuration.InternalProximityManagerConfiguration;
import com.kontakt.sdk.android.ble.monitoring.IEventCollector;
import com.kontakt.sdk.android.cloud.IKontaktCloud;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.model.Event;
import com.kontakt.sdk.android.common.model.EventPacket;
import com.kontakt.sdk.android.common.model.EventType;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class EventCollector
implements IEventCollector {
    static final String TAG = "EventCollector";
    private final EventSender eventSender;
    private InternalProximityManagerConfiguration configuration;
    private ScheduledExecutorService executorService;

    public EventCollector(IKontaktCloud kontaktCloud, InternalProximityManagerConfiguration configuration) {
        this.eventSender = new EventSender(kontaktCloud);
        this.configuration = configuration;
    }

    @Override
    public void collect(RemoteBluetoothDevice device) {
        this.eventSender.collect(device);
    }

    @Override
    public void stop() {
        if (this.executorService == null) {
            return;
        }
        this.executorService.shutdown();
        this.executorService = null;
    }

    @Override
    public void clear() {
        this.eventSender.clear();
    }

    @Override
    public void start() {
        if (this.executorService != null || !this.configuration.isMonitoringEnabled()) {
            return;
        }
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.executorService.scheduleWithFixedDelay(this.eventSender, this.configuration.getMonitoringSyncInterval(), this.configuration.getMonitoringSyncInterval(), TimeUnit.SECONDS);
    }

    @Override
    public void updateConfiguration(InternalProximityManagerConfiguration configuration) {
        this.configuration = configuration;
    }

    static class EventSender
    implements Runnable {
        private static final int DEFAULT_BUFFER_SIZE = 200;
        private final ArrayBlockingQueue<Event> eventsBuffer;
        private final IKontaktCloud kontaktCloud;
        private final ConcurrentSkipListSet<String> ignored = new ConcurrentSkipListSet();

        EventSender(IKontaktCloud kontaktCloud) {
            this.eventsBuffer = new ArrayBlockingQueue(200, true);
            this.kontaktCloud = kontaktCloud;
        }

        @Override
        public void run() {
            ArrayList<Event> events = new ArrayList<Event>();
            this.eventsBuffer.drainTo(events);
            if (events.isEmpty()) {
                Logger.d("EventCollector Nothing to send");
                return;
            }
            EventPacket eventPacket = EventPacket.from(events, System.currentTimeMillis());
            try {
                this.kontaktCloud.events().collect(eventPacket).execute();
            }
            catch (KontaktCloudException | IOException e) {
                Throwable cause = e.getCause();
                if (UnknownHostException.class.isInstance(cause) || SocketTimeoutException.class.isInstance(cause)) {
                    this.eventsBuffer.addAll(events);
                }
                Logger.e("EventCollector Error occurred when try to send monitoring events", e);
            }
        }

        void collect(RemoteBluetoothDevice device) {
            String notificationId = device.getUniqueId() + ":" + device.getBatteryPower();
            if (this.ignored.contains(notificationId)) {
                return;
            }
            Event event = Event.of(device, EventType.MONITORING);
            try {
                this.eventsBuffer.add(event);
                this.ignored.add(notificationId);
            }
            catch (IllegalStateException e) {
                Logger.e("Event collector queue is full", e);
            }
        }

        public void clear() {
            this.eventsBuffer.clear();
            this.ignored.clear();
        }
    }
}

