/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.manager.service;

import android.annotation.TargetApi;
import android.content.Context;
import com.kontakt.sdk.android.ble.manager.service.ServiceConnector;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.PermissionsUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public abstract class AbstractServiceConnector
implements ServiceConnector {
    private final String[] permissions;
    private final String[] permissionsMarshmallow;
    protected Context context;

    protected AbstractServiceConnector(Context context, String[] permissions, String[] permissionsMarshmallow) {
        SDKPreconditions.checkState(context != null, "Applied context instance is null");
        SDKPreconditions.checkState(permissions != null, "Permissions not specified");
        this.context = context.getApplicationContext();
        this.permissions = permissions;
        this.permissionsMarshmallow = permissionsMarshmallow;
    }

    @Override
    public void disconnect() {
        Logger.d(this.getClass().getSimpleName() + " disconnected.");
    }

    @TargetApi(value=15)
    protected void checkPermissions() {
        PermissionsUtils.checkPermissions(this.context, this.permissions);
        PermissionsUtils.checkAtLeastOneMarshmallowPermissionGranted(this.context, this.permissionsMarshmallow);
    }
}

