/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.manager.listeners;

import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.device.BeaconDevice;
import com.kontakt.sdk.android.ble.device.EddystoneDevice;
import com.kontakt.sdk.android.ble.device.SecureProfile;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.secure_profile.SecureProfileEvent;
import com.kontakt.sdk.android.ble.exception.ScanError;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.monitoring.IEventCollector;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.model.ResolvedId;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.common.util.SecureProfileUtils;
import java.util.LinkedList;
import java.util.List;

public class KontaktProximityListener
implements InternalProximityListener {
    private static final String TAG = "KPListener";
    private final int parentProximityManagerId;
    private final FutureShufflesCache cache;
    private final IEventCollector eventCollector;
    private InternalProximityListener internalProximityListener;

    public KontaktProximityListener(int parentProximityManagerId, InternalProximityListener internalProximityListener, FutureShufflesCache futureShuffleCache, IEventCollector eventCollector) {
        this.parentProximityManagerId = parentProximityManagerId;
        this.internalProximityListener = internalProximityListener;
        this.cache = futureShuffleCache;
        this.eventCollector = eventCollector;
    }

    @Override
    public void onScanStart() {
        this.internalProximityListener.onScanStart();
    }

    @Override
    public void onScanStop() {
        this.internalProximityListener.onScanStop();
    }

    @Override
    public void onScanError(ScanError exception) {
        this.internalProximityListener.onScanError(exception);
    }

    @Override
    public void onMonitoringCycleStart() {
        this.internalProximityListener.onMonitoringCycleStart();
    }

    @Override
    public void onMonitoringCycleStop() {
        this.internalProximityListener.onMonitoringCycleStop();
    }

    @Override
    public void onEvent(BluetoothDeviceEvent event) {
        switch (event.getEventType()) {
            case DEVICE_DISCOVERED: {
                this.handleDiscoverEvent(event);
                break;
            }
            case DEVICES_UPDATE: {
                this.handleUpdateEvent(event);
                break;
            }
            case DEVICE_LOST: {
                this.handleLostEvent(event);
                break;
            }
            default: {
                this.internalProximityListener.onEvent(event);
            }
        }
    }

    private void handleDiscoverEvent(BluetoothDeviceEvent event) {
        List<? extends RemoteBluetoothDevice> originalDevices = event.getDeviceList();
        if (originalDevices.isEmpty()) {
            return;
        }
        SDKPreconditions.checkArgument(originalDevices.size() == 1, "Only one device can be discovered at once!");
        LinkedList<RemoteBluetoothDevice> resolvedDevices = new LinkedList<RemoteBluetoothDevice>();
        for (RemoteBluetoothDevice remoteBluetoothDevice : originalDevices) {
            if (!remoteBluetoothDevice.isShuffled()) {
                Logger.d("KPListener Discover not shuffled device");
                this.eventCollector.collect(remoteBluetoothDevice);
                resolvedDevices.add(remoteBluetoothDevice);
                continue;
            }
            Logger.d("KPListener Discover shuffled device");
            ResolvedId resolvedId = this.cache.get(remoteBluetoothDevice);
            if (resolvedId == null) {
                this.cache.addResolveRequest(this.parentProximityManagerId, event);
                continue;
            }
            if (FutureShufflesCache.PHANTOM_ENTRY.equals(resolvedId)) continue;
            if (remoteBluetoothDevice.getUniqueId() == null) {
                RemoteBluetoothDevice resolvedDevice = KontaktProximityListener.getBluetoothDevice(remoteBluetoothDevice, resolvedId);
                this.eventCollector.collect(resolvedDevice);
                resolvedDevices.add(resolvedDevice);
                continue;
            }
            this.eventCollector.collect(remoteBluetoothDevice);
            this.internalProximityListener.onEvent(event);
        }
        if (resolvedDevices.isEmpty()) {
            return;
        }
        BluetoothDeviceEvent updatedEvent = KontaktProximityListener.getBluetoothDeviceEvent(event, resolvedDevices);
        this.internalProximityListener.onEvent(updatedEvent);
    }

    private void handleUpdateEvent(BluetoothDeviceEvent event) {
        List<? extends RemoteBluetoothDevice> originalDevices = event.getDeviceList();
        if (originalDevices.isEmpty()) {
            return;
        }
        LinkedList<RemoteBluetoothDevice> resolvedDevices = new LinkedList<RemoteBluetoothDevice>();
        for (RemoteBluetoothDevice remoteBluetoothDevice : originalDevices) {
            if (remoteBluetoothDevice == null) continue;
            if (!remoteBluetoothDevice.isShuffled()) {
                resolvedDevices.add(remoteBluetoothDevice);
                continue;
            }
            ResolvedId resolvedId = this.cache.get(remoteBluetoothDevice);
            if (resolvedId == null || FutureShufflesCache.PHANTOM_ENTRY.equals(resolvedId)) continue;
            RemoteBluetoothDevice resolvedDevice = KontaktProximityListener.getBluetoothDevice(remoteBluetoothDevice, resolvedId);
            resolvedDevices.add(resolvedDevice);
        }
        if (resolvedDevices.isEmpty()) {
            return;
        }
        BluetoothDeviceEvent updatedEvent = KontaktProximityListener.getBluetoothDeviceEvent(event, resolvedDevices);
        this.internalProximityListener.onEvent(updatedEvent);
    }

    private void handleLostEvent(BluetoothDeviceEvent event) {
        List<? extends RemoteBluetoothDevice> originalDevices = event.getDeviceList();
        if (originalDevices.isEmpty()) {
            return;
        }
        LinkedList<RemoteBluetoothDevice> resolvedDevices = new LinkedList<RemoteBluetoothDevice>();
        for (RemoteBluetoothDevice remoteBluetoothDevice : originalDevices) {
            if (!remoteBluetoothDevice.isShuffled()) {
                resolvedDevices.add(remoteBluetoothDevice);
                continue;
            }
            ResolvedId resolvedId = this.cache.get(remoteBluetoothDevice);
            if (resolvedId == null) {
                this.cache.markIgnored(remoteBluetoothDevice);
                continue;
            }
            if (FutureShufflesCache.PHANTOM_ENTRY.equals(resolvedId)) continue;
            RemoteBluetoothDevice resolvedDevice = KontaktProximityListener.getBluetoothDevice(remoteBluetoothDevice, resolvedId);
            resolvedDevices.add(resolvedDevice);
        }
        if (resolvedDevices.isEmpty()) {
            return;
        }
        BluetoothDeviceEvent updatedEvent = KontaktProximityListener.getBluetoothDeviceEvent(event, resolvedDevices);
        this.internalProximityListener.onEvent(updatedEvent);
    }

    public int getParentProximityManagerId() {
        return this.parentProximityManagerId;
    }

    private static RemoteBluetoothDevice getBluetoothDevice(RemoteBluetoothDevice bluetoothDevice, ResolvedId resolvedId) {
        switch (bluetoothDevice.getProfile()) {
            case IBEACON: {
                IBeaconDevice iBeaconDevice = (IBeaconDevice)bluetoothDevice;
                return BeaconDevice.of(iBeaconDevice, resolvedId);
            }
            case EDDYSTONE: {
                IEddystoneDevice eddystoneDevice = (IEddystoneDevice)bluetoothDevice;
                return new EddystoneDevice.Builder(eddystoneDevice).resolvedId(resolvedId).build();
            }
            case KONTAKT_SECURE: {
                SecureProfile secureDevice = new SecureProfile.Builder(bluetoothDevice).resolvedId(resolvedId).build();
                return SecureProfileUtils.asRemoteBluetoothDevice(secureDevice);
            }
        }
        throw new IllegalArgumentException("Unsupported device profile!");
    }

    private static BluetoothDeviceEvent getBluetoothDeviceEvent(BluetoothDeviceEvent bluetoothDeviceEvent, List<? extends RemoteBluetoothDevice> devices) {
        switch (bluetoothDeviceEvent.getDeviceProfile()) {
            case IBEACON: {
                IBeaconDeviceEvent iBeaconDeviceEvent = (IBeaconDeviceEvent)bluetoothDeviceEvent;
                List<? extends RemoteBluetoothDevice> iBeaconDevices = devices;
                return IBeaconDeviceEvent.of(iBeaconDeviceEvent, iBeaconDevices);
            }
            case EDDYSTONE: {
                EddystoneDeviceEvent eddystoneDeviceEvent = (EddystoneDeviceEvent)bluetoothDeviceEvent;
                List<? extends RemoteBluetoothDevice> eddystoneDevices = devices;
                return EddystoneDeviceEvent.of(eddystoneDeviceEvent, eddystoneDevices);
            }
            case KONTAKT_SECURE: {
                SecureProfileEvent secureProfileEvent = (SecureProfileEvent)bluetoothDeviceEvent;
                return SecureProfileEvent.of(secureProfileEvent, SecureProfileUtils.fromRemoteBluetoothDevices(devices));
            }
        }
        throw new IllegalArgumentException("Unsupported device profile!");
    }
}

