/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.manager.internal;

import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.device.BeaconRegion;
import com.kontakt.sdk.android.ble.device.EddystoneNamespace;
import com.kontakt.sdk.android.cloud.IKontaktCloud;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.response.CloudError;
import com.kontakt.sdk.android.cloud.response.CloudHeaders;
import com.kontakt.sdk.android.cloud.response.paginated.Namespaces;
import com.kontakt.sdk.android.cloud.response.paginated.Proximities;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.model.Namespace;
import com.kontakt.sdk.android.common.model.ProximityId;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

abstract class SpacesResolver<Space> {
    protected final IKontaktCloud cloud;
    protected final Map<String, Space> toResolve = new HashMap<String, Space>();
    protected final Collection<Space> resolved = new ArrayList<Space>();
    protected final Map<String, Space> cache = new HashMap<String, Space>();
    protected ResolvingStatusListener resolvingStatusListener;
    protected int maxResults = 50;
    private boolean isFinishedSuccessfully;

    public SpacesResolver(IKontaktCloud cloud) {
        this.cloud = SDKPreconditions.checkNotNull(cloud);
    }

    public void resolve(ScanContext scanContext, ResolvingStatusListener onSpacesResolvedListener) {
        this.resolvingStatusListener = SDKPreconditions.checkNotNull(onSpacesResolvedListener);
        this.isFinishedSuccessfully = false;
        this.clear();
        this.divideSpaces(this.getSpacesFromScanContext(scanContext));
        if (this.toResolve.isEmpty()) {
            this.invokeSuccessCallback();
            Logger.d("No shuffled spaces needs resolving.");
            return;
        }
        this.maxResults = this.toResolve.size() + 50;
        this.fetchSpacesFromCloud();
    }

    public void clear() {
        this.toResolve.clear();
        this.resolved.clear();
    }

    public void clearCache() {
        this.cache.clear();
    }

    public void resetFinishedStatus() {
        this.isFinishedSuccessfully = false;
    }

    public boolean isFinishedSuccessfully() {
        return this.isFinishedSuccessfully;
    }

    public Collection<Space> getResolvedSpaces() {
        return this.resolved;
    }

    protected abstract Collection<Space> getSpacesFromScanContext(ScanContext var1);

    protected abstract void divideSpaces(Collection<Space> var1);

    protected abstract void fetchSpacesFromCloud();

    protected void invokeSuccessCallback() {
        this.isFinishedSuccessfully = true;
        this.resolvingStatusListener.onSuccess();
    }

    protected void invokeErrorCallback(String message) {
        this.resolvingStatusListener.onError(message);
    }

    public static class NamespacesResolver
    extends SpacesResolver<IEddystoneNamespace> {
        public NamespacesResolver(IKontaktCloud cloud) {
            super(cloud);
        }

        @Override
        protected Collection<IEddystoneNamespace> getSpacesFromScanContext(ScanContext scanContext) {
            return scanContext.getEddystoneNamespaces();
        }

        @Override
        protected void divideSpaces(Collection<IEddystoneNamespace> namespaces) {
            for (IEddystoneNamespace namespace : namespaces) {
                if (namespace.getSecureNamespace() != null) {
                    if (this.cache.containsKey(namespace.getSecureNamespace())) {
                        this.resolved.add(this.cache.get(namespace.getSecureNamespace()));
                        continue;
                    }
                    this.toResolve.put(namespace.getSecureNamespace(), namespace);
                    continue;
                }
                this.resolved.add(namespace);
            }
        }

        @Override
        protected void fetchSpacesFromCloud() {
            this.cloud.namespaces().fetch().maxResult(this.maxResults).execute(new CloudCallback<Namespaces>(){

                @Override
                public void onSuccess(Namespaces namespaces, CloudHeaders headers) {
                    NamespacesResolver.this.resolveNamespaces((List<Namespace>)namespaces.getContent());
                    NamespacesResolver.this.invokeSuccessCallback();
                    Logger.d("Successfully fetched namespaces from Kontakt Cloud");
                }

                @Override
                public void onError(CloudError error) {
                    NamespacesResolver.this.invokeErrorCallback(error.getMessage());
                }
            });
        }

        void resolveNamespaces(List<Namespace> namespaces) {
            for (Namespace fetchedNamespace : namespaces) {
                IEddystoneNamespace namespace = (IEddystoneNamespace)this.toResolve.get(fetchedNamespace.getNamespaceId());
                if (namespace == null || !fetchedNamespace.isShuffled() || !fetchedNamespace.getNamespaceId().equals(namespace.getSecureNamespace())) continue;
                IEddystoneNamespace shuffledNamespace = this.createNewNamespace(namespace, fetchedNamespace.getNamespaceId(), fetchedNamespace.getSecureNamespaceId());
                this.resolved.add(shuffledNamespace);
                this.cache.put(namespace.getSecureNamespace(), shuffledNamespace);
            }
        }

        private IEddystoneNamespace createNewNamespace(IEddystoneNamespace oldSpace, String normalNamespace, String secureNamespace) {
            return new EddystoneNamespace.Builder().identifier(oldSpace.getIdentifier()).namespace(normalNamespace).secureNamespace(secureNamespace).build();
        }
    }

    public static class RegionsResolver
    extends SpacesResolver<IBeaconRegion> {
        public RegionsResolver(IKontaktCloud cloud) {
            super(cloud);
        }

        @Override
        protected Collection<IBeaconRegion> getSpacesFromScanContext(ScanContext scanContext) {
            return scanContext.getIBeaconRegions();
        }

        @Override
        protected void divideSpaces(Collection<IBeaconRegion> iBeaconRegions) {
            for (IBeaconRegion region : iBeaconRegions) {
                if (region.getSecureProximity() != null) {
                    if (this.cache.containsKey(region.getSecureProximity().toString())) {
                        this.resolved.add(this.cache.get(region.getSecureProximity().toString()));
                        continue;
                    }
                    this.toResolve.put(region.getSecureProximity().toString(), region);
                    continue;
                }
                this.resolved.add(region);
            }
        }

        @Override
        protected void fetchSpacesFromCloud() {
            this.cloud.proximities().fetch().maxResult(this.maxResults).execute(new CloudCallback<Proximities>(){

                @Override
                public void onSuccess(Proximities proximities, CloudHeaders headers) {
                    RegionsResolver.this.resolveRegions((List<ProximityId>)proximities.getContent());
                    RegionsResolver.this.invokeSuccessCallback();
                    Logger.d("Successfully fetched spaces from Kontakt Cloud");
                }

                @Override
                public void onError(CloudError error) {
                    RegionsResolver.this.invokeErrorCallback(error.getMessage());
                }
            });
        }

        void resolveRegions(List<ProximityId> proximityIds) {
            for (ProximityId fetchedRegion : proximityIds) {
                IBeaconRegion region = (IBeaconRegion)this.toResolve.get(fetchedRegion.getProximityUUID().toString());
                if (region == null || !fetchedRegion.isShuffled() || !fetchedRegion.getProximityUUID().equals(region.getSecureProximity())) continue;
                IBeaconRegion shuffledRegion = this.createNewRegion(region, fetchedRegion.getProximityUUID(), fetchedRegion.getSecureProximityUUID());
                this.resolved.add(shuffledRegion);
                this.cache.put(region.getSecureProximity().toString(), shuffledRegion);
            }
        }

        private IBeaconRegion createNewRegion(IBeaconRegion region, UUID normalUUID, UUID secureUUID) {
            return new BeaconRegion.Builder().proximity(normalUUID).secureProximity(secureUUID).major(region.getMajor()).minor(region.getMinor()).identifier(region.getIdentifier()).build();
        }
    }

    public static interface ResolvingStatusListener {
        public void onSuccess();

        public void onError(String var1);
    }
}

