/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.manager.configuration;

import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.InternalProximityManagerConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanPeriod;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.ScanMode;
import com.kontakt.sdk.android.ble.filter.eddystone.EddystoneFilter;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconFilter;
import com.kontakt.sdk.android.ble.manager.configuration.FiltersConfigurator;
import com.kontakt.sdk.android.ble.manager.configuration.GeneralConfigurator;
import com.kontakt.sdk.android.ble.manager.configuration.SpacesConfigurator;
import com.kontakt.sdk.android.ble.rssi.RssiCalculator;
import com.kontakt.sdk.android.ble.spec.EddystoneFrameType;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class Configuration
implements GeneralConfigurator,
SpacesConfigurator,
FiltersConfigurator {
    private ScanPeriod scanPeriod;
    private ScanMode scanMode;
    private ForceScanConfiguration forceScanConfiguration;
    private ActivityCheckConfiguration activityCheckConfiguration;
    private RssiCalculator rssiCalculator;
    private Collection<EddystoneFrameType> eddystoneFrameTypes;
    private Set<DeviceProfile> observedProfiles;
    private String cacheFileName;
    private boolean monitoringEnabled;
    private int monitoringSyncIntervalSeconds;
    private int resolveShuffledInterval;
    private long deviceUpdateCallbackInterval;
    private Collection<IBeaconRegion> iBeaconRegions;
    private Collection<IEddystoneNamespace> eddystoneNamespaces;
    private Collection<IBeaconFilter> iBeaconFilters;
    private Collection<EddystoneFilter> eddystoneFilters;

    public Configuration(ScanContext scanContext, InternalProximityManagerConfiguration proximityManagerConfiguration) {
        SDKPreconditions.checkNotNull(scanContext);
        SDKPreconditions.checkNotNull(proximityManagerConfiguration);
        this.scanPeriod = scanContext.getScanPeriod();
        this.forceScanConfiguration = scanContext.getForceScanConfiguration();
        this.activityCheckConfiguration = scanContext.getActivityCheckConfiguration();
        this.scanMode = scanContext.getScanMode();
        this.deviceUpdateCallbackInterval = scanContext.getDevicesUpdateCallbackInterval();
        this.rssiCalculator = scanContext.getRssiCalculator();
        this.eddystoneFrameTypes = Collections.unmodifiableCollection(scanContext.getEddystoneFrameTypes());
        this.observedProfiles = scanContext.getObservedProfiles();
        this.cacheFileName = proximityManagerConfiguration.getCacheFileName();
        this.monitoringEnabled = proximityManagerConfiguration.isMonitoringEnabled();
        this.monitoringSyncIntervalSeconds = proximityManagerConfiguration.getMonitoringSyncInterval();
        this.resolveShuffledInterval = proximityManagerConfiguration.getResolveInterval();
        this.iBeaconRegions = Collections.unmodifiableCollection(scanContext.getIBeaconRegions());
        this.eddystoneNamespaces = Collections.unmodifiableCollection(scanContext.getEddystoneNamespaces());
        this.iBeaconFilters = Collections.unmodifiableCollection(scanContext.getIBeaconFilters());
        this.eddystoneFilters = Collections.unmodifiableCollection(scanContext.getEddystoneFilters());
    }

    public ScanContext createScanContext() {
        return new ScanContext.Builder().setScanPeriod(this.scanPeriod).setScanMode(this.scanMode).setDevicesUpdateCallbackInterval(this.deviceUpdateCallbackInterval).setForceScanConfiguration(this.forceScanConfiguration).setActivityCheckConfiguration(this.activityCheckConfiguration).setRssiCalculator(this.rssiCalculator).setObservedProfiles(this.observedProfiles).setIBeaconRegions(this.iBeaconRegions).setIBeaconFilters(this.iBeaconFilters).setEddystoneNamespaces(this.eddystoneNamespaces).setEddystoneFilters(this.eddystoneFilters).setRequiredEddystoneFrameTypes(this.eddystoneFrameTypes).build();
    }

    public InternalProximityManagerConfiguration createKontaktManagerConfiguration() {
        return new InternalProximityManagerConfiguration.Builder().monitoringEnabled(this.monitoringEnabled).monitoringSyncInterval(this.monitoringSyncIntervalSeconds).cacheFileName(this.cacheFileName).resolveInterval(this.resolveShuffledInterval).build();
    }

    @Override
    public GeneralConfigurator scanPeriod(ScanPeriod scanPeriod) {
        this.scanPeriod = SDKPreconditions.checkNotNull(scanPeriod);
        return this;
    }

    @Override
    public GeneralConfigurator scanMode(ScanMode scanMode) {
        this.scanMode = SDKPreconditions.checkNotNull(scanMode);
        return this;
    }

    @Override
    public GeneralConfigurator forceScanConfiguration(ForceScanConfiguration forceScanConfiguration) {
        this.forceScanConfiguration = SDKPreconditions.checkNotNull(forceScanConfiguration);
        return this;
    }

    @Override
    public GeneralConfigurator activityCheckConfiguration(ActivityCheckConfiguration activityCheckConfiguration) {
        this.activityCheckConfiguration = SDKPreconditions.checkNotNull(activityCheckConfiguration);
        return this;
    }

    @Override
    public GeneralConfigurator cacheFileName(String name) {
        this.cacheFileName = SDKPreconditions.checkNotNull(name);
        return this;
    }

    @Override
    public GeneralConfigurator monitoringEnabled(boolean enabled) {
        this.monitoringEnabled = SDKPreconditions.checkNotNull(enabled);
        return this;
    }

    @Override
    public GeneralConfigurator monitoringSyncInterval(int intervalInSeconds) {
        SDKPreconditions.checkArgument(intervalInSeconds > 0);
        this.monitoringSyncIntervalSeconds = intervalInSeconds;
        return this;
    }

    @Override
    public GeneralConfigurator resolveShuffledInterval(int intervalInSeconds) {
        SDKPreconditions.checkArgument(intervalInSeconds > 0);
        this.resolveShuffledInterval = intervalInSeconds;
        return this;
    }

    @Override
    public GeneralConfigurator deviceUpdateCallbackInterval(long intervalInMillis) {
        SDKPreconditions.checkArgument(intervalInMillis > 0L);
        this.deviceUpdateCallbackInterval = intervalInMillis;
        return this;
    }

    @Override
    public GeneralConfigurator rssiCalculator(RssiCalculator rssiCalculator) {
        this.rssiCalculator = SDKPreconditions.checkNotNull(rssiCalculator);
        return this;
    }

    @Override
    public GeneralConfigurator eddystoneFrameTypes(Collection<EddystoneFrameType> eddystoneFrameTypes) {
        SDKPreconditions.checkNotNull(eddystoneFrameTypes);
        this.eddystoneFrameTypes = Collections.unmodifiableCollection(eddystoneFrameTypes);
        return this;
    }

    @Override
    public SpacesConfigurator iBeaconRegion(IBeaconRegion region) {
        SDKPreconditions.checkNotNull(region);
        this.iBeaconRegions(Collections.singletonList(region));
        return this;
    }

    @Override
    public SpacesConfigurator iBeaconRegions(Collection<IBeaconRegion> regions) {
        SDKPreconditions.checkNotNull(regions);
        this.iBeaconRegions = Collections.unmodifiableCollection(regions);
        return this;
    }

    @Override
    public SpacesConfigurator eddystoneNamespace(IEddystoneNamespace namespace) {
        SDKPreconditions.checkNotNull(namespace);
        this.eddystoneNamespaces(Collections.singletonList(namespace));
        return this;
    }

    @Override
    public SpacesConfigurator eddystoneNamespaces(Collection<IEddystoneNamespace> namespaces) {
        SDKPreconditions.checkNotNull(namespaces);
        this.eddystoneNamespaces = Collections.unmodifiableCollection(namespaces);
        return this;
    }

    @Override
    public FiltersConfigurator iBeaconFilter(IBeaconFilter filter) {
        SDKPreconditions.checkNotNull(filter);
        this.iBeaconFilters(Collections.singletonList(filter));
        return this;
    }

    @Override
    public FiltersConfigurator iBeaconFilters(Collection<IBeaconFilter> filters) {
        SDKPreconditions.checkNotNull(filters);
        this.iBeaconFilters = Collections.unmodifiableCollection(filters);
        return this;
    }

    @Override
    public FiltersConfigurator eddystoneFilter(EddystoneFilter filter) {
        SDKPreconditions.checkNotNull(filter);
        this.eddystoneFilters(Collections.singletonList(filter));
        return this;
    }

    @Override
    public FiltersConfigurator eddystoneFilters(Collection<EddystoneFilter> filters) {
        SDKPreconditions.checkNotNull(filters);
        this.eddystoneFilters = Collections.unmodifiableCollection(filters);
        return this;
    }

    @Override
    public void clearAll() {
        this.iBeaconFilters = Collections.emptyList();
        this.eddystoneFilters = Collections.emptyList();
    }

    public void addObservedProfiles(DeviceProfile deviceProfile) {
        this.observedProfiles.add(deviceProfile);
    }

    public void removeObservedProfiles(DeviceProfile deviceProfile) {
        this.observedProfiles.remove((Object)deviceProfile);
    }
}

