/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.secure_profile;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.SecureProfileUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SecureProfileEvent
implements BluetoothDeviceEvent {
    public static final Parcelable.Creator<SecureProfileEvent> CREATOR = new Parcelable.Creator<SecureProfileEvent>(){

        public SecureProfileEvent createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle(this.getClass().getClassLoader());
            EventType eventType = (EventType)((Object)bundle.getSerializable(SecureProfileEvent.PARCELABLE_EVENT_TYPE));
            ArrayList deviceList = bundle.getParcelableArrayList(SecureProfileEvent.PARCELABLE_DEVICE_LIST);
            long timestamp = bundle.getLong(SecureProfileEvent.PARCELABLE_TIMESTAMP);
            return new SecureProfileEvent(timestamp, eventType, deviceList);
        }

        public SecureProfileEvent[] newArray(int size) {
            return new SecureProfileEvent[size];
        }
    };
    protected static final String PARCELABLE_EVENT_TYPE = "kontakt_event_type";
    protected static final String PARCELABLE_DEVICE_LIST = "remote_device_list";
    protected static final String PARCELABLE_TIMESTAMP = "timestamp";
    private final long timestamp;
    private final EventType eventType;
    private final List<ISecureProfile> devices;

    public static SecureProfileEvent of(SecureProfileEvent event, List<ISecureProfile> devices) {
        return new SecureProfileEvent(event.getTimestamp(), event.getEventType(), devices);
    }

    public static SecureProfileEvent createNewDiscovered(ISecureProfile secureProfile, long timestamp) {
        return new SecureProfileEvent(timestamp, EventType.DEVICE_DISCOVERED, Collections.singletonList(secureProfile));
    }

    public static SecureProfileEvent createNewUpdated(List<ISecureProfile> secureProfiles, long timestamp) {
        return new SecureProfileEvent(timestamp, EventType.DEVICES_UPDATE, Collections.unmodifiableList(secureProfiles));
    }

    public static SecureProfileEvent createNewLost(ISecureProfile secureProfile, long timestamp) {
        return new SecureProfileEvent(timestamp, EventType.DEVICE_LOST, Collections.singletonList(secureProfile));
    }

    public SecureProfileEvent(long timestamp, EventType eventType, List<ISecureProfile> devices) {
        this.timestamp = timestamp;
        this.eventType = eventType;
        this.devices = devices;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public DeviceProfile getDeviceProfile() {
        return DeviceProfile.KONTAKT_SECURE;
    }

    public List<ISecureProfile> getSecureProfileDevices() {
        return this.devices;
    }

    @Override
    public List<? extends RemoteBluetoothDevice> getDeviceList() {
        return SecureProfileUtils.asRemoteBluetoothDevices(this.devices);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putSerializable(PARCELABLE_EVENT_TYPE, (Serializable)((Object)this.eventType));
        bundle.putParcelableArrayList(PARCELABLE_DEVICE_LIST, (ArrayList)this.devices);
        bundle.putLong(PARCELABLE_TIMESTAMP, this.timestamp);
        dest.writeBundle(bundle);
    }
}

