/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.secure_profile;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.util.SparseLongArray;
import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.discovery.secure_profile.SecureProfileEvent;
import com.kontakt.sdk.android.ble.discovery.secure_profile.SecureProfileParser;
import com.kontakt.sdk.android.ble.util.ReplacingArrayList;
import com.kontakt.sdk.android.ble.util.SafeSparseLongArray;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=18)
public class SecureProfileDiscoverer
implements BluetoothDeviceDiscoverer {
    private final List<ISecureProfile> cache;
    private final SecureProfileParser parser;
    private final ActivityCheckConfiguration activityCheckConfiguration;
    private final DiscoveryContract discoveryContract;
    private final SparseLongArray secureProfileTimestampArray;
    private final long deviceUpdateIntervalCallback;
    private long lastUpdateCallbackMillis;

    public SecureProfileDiscoverer(ScanContext scanContext, DiscoveryContract discoveryContract) {
        this.deviceUpdateIntervalCallback = scanContext.getDevicesUpdateCallbackInterval();
        this.activityCheckConfiguration = scanContext.getActivityCheckConfiguration();
        this.discoveryContract = discoveryContract;
        this.secureProfileTimestampArray = new SafeSparseLongArray();
        this.parser = new SecureProfileParser(scanContext);
        this.cache = new ReplacingArrayList<ISecureProfile>();
    }

    SecureProfileDiscoverer(ScanContext scanContext, DiscoveryContract discoveryContract, SparseLongArray secureProfileTimestampArray, List<ISecureProfile> cache) {
        this.deviceUpdateIntervalCallback = scanContext.getDevicesUpdateCallbackInterval();
        this.activityCheckConfiguration = scanContext.getActivityCheckConfiguration();
        this.discoveryContract = discoveryContract;
        this.secureProfileTimestampArray = secureProfileTimestampArray;
        this.parser = new SecureProfileParser(scanContext);
        this.cache = cache;
    }

    @Override
    public boolean performDiscovery(BluetoothDevice bluetoothDevice, int rssi, byte[] scanResult) {
        if (!this.parser.isValidSecureProfileFrame(scanResult)) {
            return false;
        }
        this.parser.parseScanRecord(scanResult);
        ISecureProfile secureProfile = this.parser.getSecureProfile(bluetoothDevice, rssi);
        this.notifySecureProfilePresent(secureProfile);
        boolean isDiscovered = this.cache.contains(secureProfile);
        if (!isDiscovered) {
            this.cache.add(secureProfile);
            this.onDiscovered(secureProfile);
        } else {
            this.onUpdated();
        }
        return true;
    }

    @Override
    public void disable() {
        this.parser.disable();
    }

    @Override
    public void evictInactiveDevices(long currentTimeMillis) {
        long inactivityTimeout = this.activityCheckConfiguration.getInactivityTimeout();
        for (ISecureProfile secureProfile : new ArrayList<ISecureProfile>(this.cache)) {
            long threshold;
            long timestamp = this.getSecureProfileTimestamp(secureProfile);
            if (timestamp == -1L || (threshold = currentTimeMillis - timestamp) <= inactivityTimeout) continue;
            this.cache.remove(secureProfile);
            this.clearBeforeLost(secureProfile);
            this.onLost(secureProfile);
            this.removeSecureProfileTimestamp(secureProfile);
        }
    }

    private void notifySecureProfilePresent(ISecureProfile secureProfile) {
        this.secureProfileTimestampArray.put(secureProfile.getMacAddress().hashCode(), System.currentTimeMillis());
    }

    private void onDiscovered(ISecureProfile secureProfile) {
        this.discoveryContract.onEvent(SecureProfileEvent.createNewDiscovered(secureProfile, System.currentTimeMillis()));
    }

    private void onUpdated() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastUpdateCallbackMillis > this.deviceUpdateIntervalCallback) {
            this.discoveryContract.onEvent(SecureProfileEvent.createNewUpdated(this.cache, currentTimeMillis));
            this.lastUpdateCallbackMillis = currentTimeMillis;
        }
    }

    private void onLost(ISecureProfile secureProfile) {
        this.discoveryContract.onEvent(SecureProfileEvent.createNewLost(secureProfile, System.currentTimeMillis()));
    }

    private void clearBeforeLost(ISecureProfile secureProfile) {
        this.parser.clearRssiCalculation(secureProfile.getMacAddress().hashCode());
    }

    private long getSecureProfileTimestamp(ISecureProfile secureProfile) {
        return this.secureProfileTimestampArray.get(secureProfile.getMacAddress().hashCode(), -1L);
    }

    private void removeSecureProfileTimestamp(ISecureProfile secureProfile) {
        int index = this.secureProfileTimestampArray.indexOfKey(secureProfile.getMacAddress().hashCode());
        if (index >= 0) {
            this.secureProfileTimestampArray.removeAt(index);
        }
    }
}

