/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery;

import android.annotation.TargetApi;
import android.util.SparseLongArray;
import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.ble.util.ReplacingArrayList;
import com.kontakt.sdk.android.ble.util.SafeSparseLongArray;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@TargetApi(value=18)
public abstract class AbstractBluetoothDeviceDiscoverer<Space, Device extends RemoteBluetoothDevice>
implements BluetoothDeviceDiscoverer {
    protected static boolean PROFILE_UNRECOGNIZED = false;
    protected static boolean PROFILE_RECOGNIZED_FILTERING_NOT_PASSED = false;
    protected static boolean PROFILE_RECOGNIZED_NO_BELONGING_SPACE_FOUND = false;
    private final List<Device> EMPTY_DEVICE_LIST = new ArrayList<Device>();
    private final DiscoveryContract discoveryContract;
    private final ActivityCheckConfiguration activityCheckConfiguration;
    private final Collection<Space> spaceSet;
    private final Map<Space, ReplacingArrayList<Device>> spaceDeviceListMap = new ConcurrentHashMap<Space, ReplacingArrayList<Device>>();
    private final SparseLongArray spaceTimestampArray;
    private final SparseLongArray deviceTimestampArray;
    private final long devicesUpdateCallbackInterval;
    private long lastCallbackTime = 0L;

    protected abstract BluetoothDeviceEvent createEvent(EventType var1, Space var2, List<Device> var3);

    protected abstract void onBeforeDeviceLost(Device var1);

    protected AbstractBluetoothDeviceDiscoverer(DiscoveryContract discoveryContract, ActivityCheckConfiguration activityCheckConfiguration, Collection<Space> spaceSet, long deviceUpdateCallbackInterval) {
        this.discoveryContract = discoveryContract;
        this.activityCheckConfiguration = activityCheckConfiguration;
        this.spaceSet = spaceSet;
        this.devicesUpdateCallbackInterval = deviceUpdateCallbackInterval;
        this.spaceTimestampArray = new SafeSparseLongArray(spaceSet.size());
        this.deviceTimestampArray = new SafeSparseLongArray();
    }

    protected void notifyDevicePresent(int deviceAddressHashcode, long timestamp) {
        this.deviceTimestampArray.put(deviceAddressHashcode, timestamp);
    }

    protected void notifySpacePresent(int spaceHashcode, long timestamp) {
        this.spaceTimestampArray.put(spaceHashcode, timestamp);
    }

    protected Collection<Space> getSpaceSet() {
        return this.spaceSet;
    }

    protected ReplacingArrayList<Device> getDevicesInSpace(Space space) {
        return this.spaceDeviceListMap.get(space);
    }

    protected void insertDevicesIntoSpace(Space space, ReplacingArrayList<Device> deviceList) {
        this.spaceDeviceListMap.put(space, deviceList);
    }

    protected void onSpaceEnteredEvent(Space space) {
        this.discoveryContract.onEvent(this.createEvent(EventType.SPACE_ENTERED, space, this.EMPTY_DEVICE_LIST));
    }

    protected void onDeviceDiscoveredEvent(Space space, Device device) {
        ArrayList<Device> deviceList = new ArrayList<Device>(1);
        deviceList.add(device);
        this.discoveryContract.onEvent(this.createEvent(EventType.DEVICE_DISCOVERED, space, deviceList));
    }

    protected void onDevicesUpdatedEvent(Space space, Collection<Device> deviceList) {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.lastCallbackTime + this.devicesUpdateCallbackInterval > currentTimeMillis) {
            return;
        }
        this.discoveryContract.onEvent(this.createEvent(EventType.DEVICES_UPDATE, space, new ArrayList<Device>(deviceList)));
        this.lastCallbackTime = currentTimeMillis;
    }

    protected void onDeviceLostEvent(Space space, Device device) {
        ArrayList<Device> deviceList = new ArrayList<Device>(1);
        deviceList.add(device);
        this.discoveryContract.onEvent(this.createEvent(EventType.DEVICE_LOST, space, deviceList));
    }

    protected void onSpaceAbandonedEvent(Space space) {
        this.discoveryContract.onEvent(this.createEvent(EventType.SPACE_ABANDONED, space, this.EMPTY_DEVICE_LIST));
    }

    @Override
    public void evictInactiveDevices(long currentTimeMillis) {
        long inactivityTimeout = this.activityCheckConfiguration.getInactivityTimeout();
        for (Map.Entry<Space, ReplacingArrayList<Device>> entry : this.spaceDeviceListMap.entrySet()) {
            Space space = entry.getKey();
            Iterator iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                long threshold;
                RemoteBluetoothDevice remoteDevice = (RemoteBluetoothDevice)iterator.next();
                long deviceTimestamp = this.deviceTimestampArray.get(remoteDevice.getAddress().hashCode(), -1L);
                if (deviceTimestamp == -1L || (threshold = currentTimeMillis - deviceTimestamp) <= inactivityTimeout) continue;
                iterator.remove();
                this.onBeforeDeviceLost(remoteDevice);
                this.onDeviceLostEvent(space, remoteDevice);
                this.removeDeviceTimestamp(remoteDevice);
            }
        }
        this.evictInactiveRegions(inactivityTimeout, currentTimeMillis);
    }

    private void evictInactiveRegions(long inactivityTimeout, long currentTimeMillis) {
        HashSet<Space> spaces = new HashSet<Space>(this.spaceDeviceListMap.keySet());
        for (Object space : spaces) {
            long threshold;
            long regionTimestamp = this.spaceTimestampArray.get(space.hashCode(), -1L);
            if (regionTimestamp == -1L || (threshold = currentTimeMillis - regionTimestamp) <= inactivityTimeout) continue;
            this.spaceDeviceListMap.remove(space);
            this.onSpaceAbandonedEvent(space);
            this.removeSpaceTimestamp(space);
        }
    }

    private void removeDeviceTimestamp(Device remoteDevice) {
        int index = this.deviceTimestampArray.indexOfKey(remoteDevice.getAddress().hashCode());
        if (index >= 0) {
            this.deviceTimestampArray.removeAt(index);
        }
    }

    private void removeSpaceTimestamp(Space space) {
        int index = this.spaceTimestampArray.indexOfKey(space.hashCode());
        if (index >= 0) {
            this.spaceTimestampArray.removeAt(index);
        }
    }
}

