/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.configuration;

import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.regex.Pattern;

public final class InternalProximityManagerConfiguration {
    static final int MIN_RESOLVE_INTERVAL = 0;
    static final int MIN_MONITORING_SYNC_INTERVAL = 0;
    private static final String FILE_NAME_REGEX = "^[^(^?|*<\":>+\\[\\]\\/'{})]+$";
    static final Pattern FILE_NAME_MATCHER = Pattern.compile("^[^(^?|*<\":>+\\[\\]\\/'{})]+$");
    public static final String DEFAULT_CACHE_FILE_NAME = "resolved.che";
    public static final int DEFAULT_RESOLVE_INTERVAL = 3;
    public static final int DEFAULT_MONITORING_SYNC_INTERVAL = 10;
    public static final boolean DEFAULT_MONITORING_ENABLED = true;
    public static final InternalProximityManagerConfiguration DEFAULT = new Builder().cacheFileName("resolved.che").resolveInterval(3).monitoringSyncInterval(10).monitoringEnabled(true).build();
    private final String cacheFileName;
    private final int resolveInterval;
    private final int monitoringSyncInterval;
    private final boolean monitoringEnabled;

    InternalProximityManagerConfiguration(Builder builder) {
        this.cacheFileName = builder.cacheFileName;
        this.resolveInterval = builder.resolveInterval;
        this.monitoringSyncInterval = builder.monitoringSyncInterval;
        this.monitoringEnabled = builder.monitoringEnabled;
    }

    public String getCacheFileName() {
        return this.cacheFileName;
    }

    public int getResolveInterval() {
        return this.resolveInterval;
    }

    public int getMonitoringSyncInterval() {
        return this.monitoringSyncInterval;
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public static class Builder {
        String cacheFileName = "resolved.che";
        int resolveInterval = 3;
        boolean monitoringEnabled = true;
        int monitoringSyncInterval = 10;

        public Builder cacheFileName(String cacheFileName) {
            SDKPreconditions.checkNotNull(cacheFileName, "Cache file name cannot be null!");
            boolean match = FILE_NAME_MATCHER.matcher(cacheFileName).matches();
            SDKPreconditions.checkArgument(match, "Incorrect cache file name");
            this.cacheFileName = cacheFileName;
            return this;
        }

        public Builder resolveInterval(int resolveIntervalSeconds) {
            SDKPreconditions.checkArgument(resolveIntervalSeconds > 0, "Resolve interval must be greater than 0!");
            this.resolveInterval = resolveIntervalSeconds;
            return this;
        }

        public Builder monitoringSyncInterval(int monitoringSyncIntervalSeconds) {
            SDKPreconditions.checkArgument(monitoringSyncIntervalSeconds > 0, "Monitoring sync interval must be greater than 0!");
            this.monitoringSyncInterval = monitoringSyncIntervalSeconds;
            return this;
        }

        public Builder monitoringEnabled(boolean monitoringEnabled) {
            this.monitoringEnabled = monitoringEnabled;
            return this;
        }

        public InternalProximityManagerConfiguration build() {
            return new InternalProximityManagerConfiguration(this);
        }
    }
}

