/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.cache;

import com.kontakt.sdk.android.ble.cache.ResolveRequestStatus;
import com.kontakt.sdk.android.ble.cache.ResolverType;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.ble.discovery.secure_profile.SecureProfileEvent;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.List;

class SecureProfileResolveRequest {
    private final ISecureProfile fakeDevice;
    private final Integer sourceProximityManagerId;
    private final long timestamp;
    private ResolverType resolvedBy = ResolverType.NONE;
    private ResolveRequestStatus status;

    public SecureProfileResolveRequest(Integer sourceProximityManagerId, ISecureProfile secureProfile, long timestamp) {
        this.sourceProximityManagerId = sourceProximityManagerId;
        this.fakeDevice = secureProfile;
        this.timestamp = timestamp;
    }

    static SecureProfileResolveRequest of(int sourceProximityManagerId, BluetoothDeviceEvent bluetoothDeviceEvent) {
        SecureProfileEvent event = (SecureProfileEvent)bluetoothDeviceEvent;
        EventType eventType = event.getEventType();
        SDKPreconditions.checkArgument(EventType.DEVICE_DISCOVERED == eventType, "Cannot create resolve request for other event type than DEVICE_DISCOVERED!");
        List<ISecureProfile> discoveredDeviceList = event.getSecureProfileDevices();
        SDKPreconditions.checkState(discoveredDeviceList.size() == 1, "Resolve request must be created for each one discovered device!");
        ISecureProfile secureProfile = discoveredDeviceList.get(0);
        long timestamp = bluetoothDeviceEvent.getTimestamp();
        return new SecureProfileResolveRequest(sourceProximityManagerId, secureProfile, timestamp);
    }

    public ISecureProfile getFakeDevice() {
        return this.fakeDevice;
    }

    public Integer getSourceProximityManagerId() {
        return this.sourceProximityManagerId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ResolverType getResolvedBy() {
        return this.resolvedBy;
    }

    public void setResolvedBy(ResolverType resolvedBy) {
        this.resolvedBy = resolvedBy;
    }

    public void setStatus(ResolveRequestStatus status) {
        this.status = status;
    }

    public ResolveRequestStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SecureProfileResolveRequest)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        SecureProfileResolveRequest resolveRequest = (SecureProfileResolveRequest)o;
        return SDKEqualsBuilder.start().equals(this.fakeDevice, resolveRequest.fakeDevice).equals(this.sourceProximityManagerId, resolveRequest.sourceProximityManagerId).equals(this.timestamp, resolveRequest.timestamp).equals((Object)this.resolvedBy, (Object)resolveRequest.resolvedBy).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.fakeDevice).append(this.sourceProximityManagerId).append(this.timestamp).append((Object)this.resolvedBy).build();
    }
}

