/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.cache;

import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.cache.IBeaconApiResolveStrategy;
import com.kontakt.sdk.android.ble.cache.IBeaconCacheResolveStrategy;
import com.kontakt.sdk.android.ble.cache.IBeaconResolveRequest;
import com.kontakt.sdk.android.ble.cache.IBeaconResolveStrategy;
import com.kontakt.sdk.android.ble.cache.ResolveRequestStatus;
import com.kontakt.sdk.android.ble.cache.ResolverType;
import com.kontakt.sdk.android.ble.device.BeaconDevice;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconDeviceEvent;
import com.kontakt.sdk.android.cloud.IKontaktCloud;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.model.IBeaconFutureId;
import com.kontakt.sdk.android.common.model.IBeaconId;
import com.kontakt.sdk.android.common.model.ResolvedId;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;

class IBeaconIdResolver
implements Runnable {
    private static final String TAG = "IBeaconIdResolver";
    private static final int REQUEST_UNIT_SIZE = 70;
    private static final int DEFAULT_BUFFER_SIZE = 200;
    private static final DeviceProfile DEVICE_PROFILE = DeviceProfile.IBEACON;
    private final ArrayBlockingQueue<IBeaconResolveRequest> requestQueue;
    private final FutureShufflesCache cache;
    private final Collection<IBeaconResolveStrategy> strategies;

    IBeaconIdResolver(FutureShufflesCache futureShufflesCache, IKontaktCloud kontaktCloud) {
        this.cache = futureShufflesCache;
        this.requestQueue = new ArrayBlockingQueue(200, true);
        LinkedList<IBeaconResolveStrategy> resolvers = new LinkedList<IBeaconResolveStrategy>();
        IBeaconCacheResolveStrategy cacheStrategy = new IBeaconCacheResolveStrategy(this.cache);
        IBeaconApiResolveStrategy apiStrategy = new IBeaconApiResolveStrategy(kontaktCloud);
        resolvers.add(cacheStrategy);
        resolvers.add(apiStrategy);
        this.strategies = Collections.unmodifiableCollection(resolvers);
    }

    @Override
    public void run() {
        if (!this.cache.isInitialized()) {
            Logger.d("IBeaconIdResolver Cache not initialized yet");
            return;
        }
        ArrayList<IBeaconResolveRequest> requests = new ArrayList<IBeaconResolveRequest>();
        this.requestQueue.drainTo(requests, 70);
        if (requests.isEmpty()) {
            Logger.d("IBeaconIdResolver Nothing to resolve");
            return;
        }
        try {
            Logger.d("IBeaconIdResolver Start resolving");
            Map<IBeaconId, IBeaconResolveRequest> requestsRegister = this.buildRequestsRegister(requests);
            List<IBeaconFutureId> shuffles = this.resolveShuffles(requestsRegister);
            Map<IBeaconId, IBeaconFutureId> shufflesRegister = this.buildShufflesRegister(shuffles);
            this.evictOutdatedCacheEntries(requestsRegister, shufflesRegister);
            this.handleRequests(requestsRegister, shufflesRegister);
            this.cache.serialize();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (UnknownHostException.class.isInstance(cause) || SocketTimeoutException.class.isInstance(cause)) {
                this.requestQueue.addAll(requests);
            }
            Logger.e("IBeaconIdResolver Error occurs when try to resolve shuffled device ", e);
        }
    }

    void addResolveRequest(IBeaconResolveRequest request) {
        if (this.requestQueue.contains(request)) {
            return;
        }
        try {
            this.requestQueue.add(request);
        }
        catch (IllegalStateException fullQueueException) {
            Logger.e("Could not add iBeacon to resolve", fullQueueException);
        }
    }

    public void markIgnored(RemoteBluetoothDevice beacon) {
        for (IBeaconResolveRequest request : this.requestQueue) {
            if (!request.getFakeDevice().equals(beacon)) continue;
            request.setStatus(ResolveRequestStatus.IGNORED);
        }
    }

    public void clear() {
        this.requestQueue.clear();
    }

    private Map<IBeaconId, IBeaconResolveRequest> buildRequestsRegister(List<IBeaconResolveRequest> requests) {
        HashMap<IBeaconId, IBeaconResolveRequest> requestsRegister = new HashMap<IBeaconId, IBeaconResolveRequest>();
        for (IBeaconResolveRequest request : requests) {
            IBeaconId beaconId = IBeaconId.fromDevice(request.getFakeDevice());
            requestsRegister.put(beaconId, request);
        }
        return requestsRegister;
    }

    private List<IBeaconFutureId> resolveShuffles(Map<IBeaconId, IBeaconResolveRequest> requestsRegister) throws Exception {
        ArrayList<IBeaconFutureId> shuffles = new ArrayList<IBeaconFutureId>();
        for (IBeaconResolveStrategy strategy : this.strategies) {
            List<IBeaconFutureId> resolved = strategy.resolve(requestsRegister);
            shuffles.addAll(resolved);
        }
        return shuffles;
    }

    private Map<IBeaconId, IBeaconFutureId> buildShufflesRegister(List<IBeaconFutureId> shuffles) {
        HashMap<IBeaconId, IBeaconFutureId> shufflesRegister = new HashMap<IBeaconId, IBeaconFutureId>();
        for (IBeaconFutureId futureShuffle : shuffles) {
            shufflesRegister.put(futureShuffle.getQueriedBy(), futureShuffle);
        }
        return shufflesRegister;
    }

    private void evictOutdatedCacheEntries(Map<IBeaconId, IBeaconResolveRequest> requestsRegister, Map<IBeaconId, IBeaconFutureId> shufflesRegister) {
        ArrayList<String> uniqueIds = new ArrayList<String>();
        for (Map.Entry<IBeaconId, IBeaconResolveRequest> entry : requestsRegister.entrySet()) {
            IBeaconId queriedBy = entry.getKey();
            IBeaconResolveRequest request = entry.getValue();
            IBeaconFutureId iBeaconShuffles = shufflesRegister.get(queriedBy);
            if (iBeaconShuffles == null || ResolverType.CACHE == request.getResolvedBy()) continue;
            uniqueIds.add(iBeaconShuffles.getUniqueId());
        }
        this.cache.evict(uniqueIds, DEVICE_PROFILE);
    }

    private void handleRequests(Map<IBeaconId, IBeaconResolveRequest> requestsRegister, Map<IBeaconId, IBeaconFutureId> shufflesRegister) {
        for (Map.Entry<IBeaconId, IBeaconResolveRequest> entry : requestsRegister.entrySet()) {
            this.handleRequest(shufflesRegister, entry);
        }
    }

    private void handleRequest(Map<IBeaconId, IBeaconFutureId> shufflesRegister, Map.Entry<IBeaconId, IBeaconResolveRequest> entry) {
        IBeaconId queriedBy = entry.getKey();
        IBeaconFutureId iBeaconShuffles = shufflesRegister.get(queriedBy);
        if (iBeaconShuffles == null) {
            this.cache.populate(queriedBy.toString(), FutureShufflesCache.PHANTOM_ENTRY);
            return;
        }
        IBeaconResolveRequest request = entry.getValue();
        IBeaconId resolvedId = iBeaconShuffles.getResolved();
        String uniqueId = iBeaconShuffles.getUniqueId();
        ResolvedId resolvedBeaconId = ResolvedId.create(resolvedId.toString(), uniqueId, DEVICE_PROFILE);
        if (ResolverType.CACHE != request.getResolvedBy()) {
            this.addNewCacheEntries(iBeaconShuffles, resolvedBeaconId);
        }
        if (ResolveRequestStatus.RESOLVED == request.getStatus()) {
            this.notifyListeners(request, resolvedBeaconId);
        }
    }

    private void addNewCacheEntries(IBeaconFutureId iBeaconShuffles, ResolvedId resolvedBeaconId) {
        for (IBeaconId futureShuffle : iBeaconShuffles.getFutureIds()) {
            this.cache.populate(futureShuffle.toString(), resolvedBeaconId);
        }
        this.cache.populate(resolvedBeaconId.getIBeaconId().toString(), resolvedBeaconId);
    }

    private void notifyListeners(IBeaconResolveRequest request, ResolvedId resolvedBeaconId) {
        IBeaconDevice fakeDevice = request.getFakeDevice();
        BeaconDevice resolvedDevice = BeaconDevice.of(fakeDevice, resolvedBeaconId);
        Integer proximityManagerId = request.getSourceProximityManagerId();
        IBeaconDeviceEvent deviceEvent = IBeaconDeviceEvent.createNewDiscovered(resolvedDevice, request.getRegion(), request.getTimestamp());
        this.cache.notifyListeners(proximityManagerId, deviceEvent);
    }
}

