package com.kontakt.sdk.android.cloud.api.executor.triggers;

import com.kontakt.sdk.android.cloud.CloudConstants;
import com.kontakt.sdk.android.cloud.api.TriggersApi;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.TriggersService;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

/**
 * Request executor provided by {@link TriggersApi}. Use this class if you want to delete
 * triggers through fluent API in chained fashion, for example:
 * <pre>
 *   <code>
 *   IKontaktCloud kontaktCloud = KontaktCloud.newInstance();
 *   kontaktCloud.triggers().delete(ID).execute();
 *   </code>
 * </pre>
 */
public class DeleteTriggerRequestExecutor extends RequestExecutor<String> {

  private final TriggersService triggersService;
  private final UUID id;

  /**
   * Constructs request executor initialized with corresponding service class and trigger's identifier.
   *
   * @param triggersService the trigger API service.
   * @param id the trigger's unique identifier.
   */
  public DeleteTriggerRequestExecutor(final TriggersService triggersService, final UUID id) {
    this.triggersService = triggersService;
    this.id = id;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Call<String> prepareCall() {
    return triggersService.delete(params());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Map<String, String> params() {
    final Map<String, String> params = new HashMap<>();
    params.put(CloudConstants.Triggers.TRIGGER_ID_PARAMETER, id.toString());
    return params;
  }
}
