package com.kontakt.sdk.android.cloud.api.executor.managers;

import com.kontakt.sdk.android.cloud.CloudConstants;
import com.kontakt.sdk.android.cloud.api.ManagersApi;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ManagersService;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

/**
 * Request executor provided by {@link ManagersApi}. Use this class if you want to delete
 * managers through fluent API in chained fashion, for instance:
 * <pre>
 *   <code>
 *   IKontaktCloud kontaktCloud = KontaktCloud.newInstance();
 *   kontaktCloud.managers().delete(ID).execute();
 *   </code>
 * </pre>
 */
public class DeleteManagerRequestManager extends RequestExecutor<String> {

  private final ManagersService managersService;
  private final UUID managerId;

  /**
   * Constructs request executor initialized with corresponding service class and manager's id.
   *
   * @param managersService the managers API service.
   * @param managerId the manager's unique identifier.
   */
  public DeleteManagerRequestManager(final ManagersService managersService, final UUID managerId) {
    this.managersService = managersService;
    this.managerId = managerId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Call<String> prepareCall() {
    return managersService.deleteManager(params());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Map<String, String> params() {
    final Map<String, String> params = new HashMap<>();
    params.put(CloudConstants.Managers.MANAGER_ID_PARAMETER, managerId.toString());
    return params;
  }
}
