package com.kontakt.sdk.android.cloud;

/**
 * Kontakt.io Proximity REST API string constants.
 */
public final class CloudConstants {

  private CloudConstants() {
    // prevent from creation
  }

  /**
   * Common constants.
   */
  public static class Common {
    private Common() {
      // prevent from creation
    }

    public static final String UNIQUE_ID_PARAMETER = "uniqueId";
    public static final String ID_PARAMETER = "id";
    public static final String LAT_PARAMETER = "lat";
    public static final String LNG_PARAMETER = "lng";
    public static final String ACCESS_PARAMETER = "access";
    public static final String MAX_RESULT_PARAMETER = "maxResult";
    public static final String START_INDEX_PARAMETER = "startIndex";
    public static final String QUERY_PARAMETER = "q";
    public static final String ORDER_PARAMETER = "order";
    public static final String ORDER_BY_PARAMETER = "orderBy";
  }

  /**
   * Headers constants.
   */
  public static class MainHeaders {
    private MainHeaders() {
      // prevent from creation
    }

    public static final String API_KEY = "Api-Key";
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_VND = "application/vnd.com.kontakt+json; version=%d";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String X_WWW_FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    public static final String MULTI_PART_FORM_DATA = "multipart/form-data";
    public static final String KONTAKT_AGENT = "x-kontakt-agent";
    public static final String KONTAKT_AGENT_ANDROID = "sdk-%d-Android-%d";
    public static final String ETAG_REQUEST = "If-None-Match";
    public static final String ETAG_RESPONSE = "ETag";
  }

  /**
   * Actions API endpoint constants.
   */
  public static class Actions {
    private Actions() {
      // prevent from creation
    }

    public static final String ACTION_TYPE_PARAMETER = "actionType";
    public static final String PROXIMITY_PARAMETER = "proximity";
    public static final String URL_PARAMETER = "url";
    public static final String DEVICE_UNIQUE_IDS_PARAMETER = "deviceUniqueIds";
    public static final String CONTENT_PARAMETER = "content";
    public static final String CONTENT_LENGTH_PARAMETER = "contentLength";
    public static final String CONTENT_TYPE_PARAMETER = "contentType";
    public static final String CONTENT_CATEGORY_PARAMETER = "contentCategory";
    public static final String CONVERSION_IN_PROGRESS_PARAMETER = "conversionInProgress";
    public static final String FILE_PARAMETER = "file";
    public static final String ACTION_ID_PARAMETER = "actionId";
    public static final String ACTIONS = "actions";
  }

  /**
   * Configs API endpoint constants.
   */
  public static class Configs {
    private Configs() {
      // prevent from creation
    }

    public static final String CONFIG_JSON_PARAMETER = "configs";
    public static final String DEVICE_TYPE_PARAMETER = "deviceType";
    public static final String PROXIMITY_PARAMETER = "proximity";
    public static final String MAJOR_PARAMETER = "major";
    public static final String MINOR_PARAMETER = "minor";
    public static final String TX_POWER_PARAMETER = "txPower";
    public static final String INTERVAL_PARAMETER = "interval";
    public static final String NAMESPACE_PARAMETER = "namespace";
    public static final String URL_PARAMETER = "url";
    public static final String INSTANCE_ID_PARAMETER = "instanceId";
    public static final String PROFILE_PARAMETER = "profile";
    public static final String PROFILES_PARAMETER = "profiles";
    public static final String PACKETS_PARAMETER = "packets";
    public static final String SHUFFLED_PARAMETER = "shuffled";
    public static final String PASSWORD_PARAMETER = "password";
    public static final String NAME_PARAMETER = "name";

    //Power Saving
    public static final String POWER_SAVING_PREFIX = "powerSaving";
    public static final String FEATURES_PARAMETER = "features";
    public static final String MOVE_SUSPEND_TIMEOUT_PARAMETER = "moveSuspendTimeout";
    public static final String LIGHT_SENSOR_THRESHOLD_PARAMETER = "lightSensorThreshold";
    public static final String LIGHT_SENSOR_HYSTERESIS_PARAMETER = "lightSensorHysteresis";
    public static final String LIGHT_SENSOR_SAMPLING_INTERVAL_PARAMETER = "lightSensorSamplingInterval";

    // secure config parameters
    public static final String SECURE_REQUEST_PARAMETER = "config";
    public static final String SECURE_RESPONSE_PARAMETER = "response";
    public static final String SECURE_RESPONSE_TIME_PARAMETER = "updated";
  }

  /**
   * Devices API endpoint constants.
   */
  public static class Devices {
    private Devices() {
      // prevent from creation
    }

    public static final String DEVICES_JSON_PARAMETER = "devices";
    public static final String CONFIG_PARAMETER = "config";
    public static final String MANAGER_ID_PARAMETER = "managerId";
    public static final String BEACON_ID_PARAMETER = "beaconId";
    public static final String VENUE_ID_PARAMETER = "venueId";
    public static final String VENUE_PARAMETER = "venue";
    public static final String DEVICE_ID_PARAMETER = "deviceId";
    public static final String COMPANY_ID_PARAMETER = "companyId";
    public static final String FUTURE_ID_PARAMETER = "futureId";
    public static final String EDDYSTONE_PARAMETER = "EDDYSTONE";
    public static final String IBEACON_PARAMETER = "IBEACON";
    public static final String EDDYSTONE_UID_PARAMETER = "euid";
    public static final String EDDYSTONE_EID_PARAMETER = "eid";
    public static final String EDDYSTONE_ETLM_FRAME = "frame";
    public static final String IBEACON_ID_PARAMETER = "bid";
    public static final String MAC_PARAMETER = "mac";
    public static final String PROFILE_PARAMETER = "profile";
    public static final String DEVICE_TYPE_PARAMETER = "deviceType";
    public static final String PROXIMITY_PARAMETER = "proximity";
    public static final String MAJOR_PARAMETER = "major";
    public static final String MINOR_PARAMETER = "minor";
    public static final String PASSWORD_PARAMETER = "password";
    public static final String TX_POWER_PARAMETER = "txPower";
    public static final String INTERVAL_PARAMETER = "interval";
    public static final String ALIAS_PARAMETER = "alias";
    public static final String NAME_PARAMETER = "name";
    public static final String NAMESPACE_PARAMETER = "namespace";
    public static final String INSTANCE_ID_PARAMETER = "instanceId";
    public static final String URL_PARAMETER = "url";
    public static final String MANAGER_EMAIL_PARAMETER = "managerEmail";
    public static final String FIRMWARE_PARAMETER = "firmware";
    public static final String PROFILES_PARAMETER = "profiles";
    public static final String SECURE_PROXIMITY_PARAMETER = "secureProximity";
    public static final String SECURE_NAMESPACE_PARAMETER = "secureNamespace";
    public static final String SPECIFICATION_PARAMETER = "specification";
    public static final String MODEL_PARAMETER = "model";
    public static final String ACTIONS_COUNT_PARAMETER = "actionsCount";
    public static final String RESPONSE_PARAMETER = "response";
    public static final String UPDATED_AT_PARAMETER = "updated";
    public static final String WITH_META_DATA_PARAMETER = "withMetaData";
    public static final String EXPIRATION_DATE_PARAMETER = "expirationDate";
    public static final String QUERIED_BY_PARAMETER = "queriedBy";
    public static final String FORCE_UPDATE = "force";
    public static final String PROPERTIES_PARAMETER = "properties";
    public static final String POWER_SAVING = "powerSaving";
    public static final String SUBSCRIPTION_PLAN = "subscriptionPlan";
  }

  /**
   * Firmwares API endpoint constants.
   */
  public static class Firmwares {
    private Firmwares() {
      // prevent from creation
    }

    public static final String TYPE_PARAMETER = "type";
    public static final String NAME_PARAMETER = "name";
  }

  /**
   * Managers API endpoint constants.
   */
  public static class Managers {
    private Managers() {
      // prevent from creation
    }

    public static final String MANAGERS_PARAMETER = "managers";
    public static final String SUPERVISOR_ID_PARAMETER = "supervisorId";
    public static final String MANAGER_ID_PARAMETER = "managerId";
    public static final String FIRST_NAME_PARAMETER = "firstName";
    public static final String LAST_NAME_PARAMETER = "lastName";
    public static final String EMAIL_PARAMETER = "email";
    public static final String ROLE_PARAMETER = "role";
  }

  /**
   * Venues API endpoint constants.
   */
  public static class Venues {
    private Venues() {
      // prevent from creation
    }

    public static final String VENUES_JSON_PARAMETER = "venues";
    public static final String VENUE_ID_PARAMETER = "venueId";
    public static final String VENUE_TYPE_PARAMETER = "venueType";
    public static final String MANAGER_ID_PARAMETER = "managerId";
    public static final String SHARES_PARAMETER = "shares";
    public static final String COVER_TYPE_PARAMETER = "coverType";
    public static final String IMAGE_PARAMETER = "image";
    public static final String METADATA_PARAMETER = "metadata";
    public static final String DEVICES_COUNT_PARAMETER = "devicesCount";
    public static final String NAME_PARAMETER = "name";
    public static final String DESCRIPTION_PARAMETER = "description";
    public static final String FILE_PARAMETER = "file";
    public static final String WITH_META_DATA_PARAMETER = "withMetaData";
    public static final String EXPIRATION_DATE_PARAMETER = "expirationDate";
  }

  /**
   * Triggers API endpoint constants.
   */
  public static class Triggers {
    private Triggers() {
      // prevent from creation
    }

    public static final String TRIGGER_ID_PARAMETER = "triggerId";
    public static final String NAME_PARAMETER = "name";
    public static final String TYPE_PARAMETER = "type";
    public static final String CONTEXT_PROXIMITY_PARAMETER = "context.proximity";
    public static final String CONTEXT_TRACKING_ID_PARAMETER = "context.trackingId";
    public static final String CONTEXT_SOURCE_ID_PARAMETER = "context.sourceId";
  }

  /**
   * Activities API endpoint constants.
   */
  public static class Activities {
    private Activities() {
      // prevent from creation
    }

    public static final String ACTIVITY_ID_PARAMETER = "activityId";
    public static final String TRIGGER_ID_PARAMETER = "triggerId";
    public static final String NAME_PARAMETER = "name";
    public static final String TYPE_PARAMETER = "type";
    public static final String CONTEXT_HTTP_METHOD = "context.httpMethod";
    public static final String CONTEXT_URL = "context.url";
    public static final String CONTEXT_HEADERS = "context.headers.";
    public static final String CONTEXT_PARAMETERS = "context.params.";
  }

  /**
   * Proximities API endpoint constants.
   */
  public static class Proximities {
    private Proximities() {
      // prevent from creation
    }

    public static final String PROXIMITY_PARAMETER = "proximity";
  }

  /**
   * Namespaces API endpoint constants.
   */
  public static class Namespaces {
    private Namespaces() {
      // prevent from creation
    }

    public static final String NAMESPACE_PARAMETER = "namespace";
  }

  /**
   * Commands API endpoint constants.
   */
  public static class Commands {
    private Commands() {
      // prevent from creation
    }

    public static final String COMMAND_PARAMETER = "command";
  }

  /**
   * Events API endpoint constants.
   */
  public static class Events {
    private Events() {
      // prevent from creation
    }

    public static final String TIMESTAMP_PARAMETER = "timestamp";
    public static final String EVENTS_PARAMETER = "events";
  }

  public static class Notifications {
    private Notifications() {
      // prevent from creation
    }

    public static final String TOKEN_PARAMETER = "token";
    public static final String PLATFORM_PARAMETER = "platform";
    public static final String BUNDLE_ID_PARAMETER = "bundleId";
    public static final String SANDBOX_PARAMETER = "sandbox";
  }
}
