package com.kontakt.sdk.android.ble.service;

import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.Collection;
import java.util.Collections;

final class Callbacks {

  static BleScanCallback newCallback(ScanContext scanContext) {
    return newCallback(scanContext, Collections.<InternalProximityListener>emptyList());
  }

  static BleScanCallback newCallback(ScanContext scanContext, Collection<InternalProximityListener> listeners) {
    SDKPreconditions.checkNotNull(scanContext);
    SDKPreconditions.checkNotNull(listeners);
    return new MonitorCallback(scanContext, Collections.unmodifiableCollection(listeners)) {
    };
  }
}
