package com.kontakt.sdk.android.ble.manager.listeners;

import com.kontakt.sdk.android.common.profile.ISecureProfile;
import java.util.List;

/**
 * Listener used to report Kontakt.io secure profiles scanning results.
 */
public interface SecureProfileListener {

  /**
   * Called when secure profile is discovered for the first time.
   * This will be called only once per scan or after profile is reported lost.
   *
   * @param profile the Kontakt.io secure profile.
   */
  void onProfileDiscovered(ISecureProfile profile);

  /**
   * Called when secure profiles are updated.
   *
   * @param profiles the Kontakt.io secure profiles.
   */
  void onProfilesUpdated(List<ISecureProfile> profiles);

  /**
   * Called when secure profile is reported lost (out of range).
   * {@code onProfileDiscovered} will be called when beacon is back in range.
   *
   * @param profile the Kontakt.io secure profile.
   */
  void onProfileLost(ISecureProfile profile);
}
