package com.kontakt.sdk.android.ble.manager.configuration;

import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import java.util.Collection;

/**
 * This class is responsible for ranging/monitoring configuration.
 */
public interface SpacesConfigurator {

  /**
   * Sets IBeacon region within which IBeacon devices are searched.
   *
   * @param region the IBeacon region
   * @return ProximityManagerSpaces builder
   */
  SpacesConfigurator iBeaconRegion(IBeaconRegion region);

  /**
   * Sets IBeacon regions within which IBeacon devices are searched.
   *
   * @param regions the IBeacon regions
   * @return ProximityManagerSpaces builder
   */
  SpacesConfigurator iBeaconRegions(Collection<IBeaconRegion> regions);

  /**
   * Sets Eddystone namespace within which Eddystone devices are searched.
   *
   * @param namespace the eddystone namespaces
   * @return ProximityManagerSpaces builder
   */
  SpacesConfigurator eddystoneNamespace(IEddystoneNamespace namespace);

  /**
   * Sets Eddystone namespaces within which Eddystone devices are searched.
   *
   * @param namespaces the eddystone namespaces
   * @return ProximityManagerSpaces builder
   */
  SpacesConfigurator eddystoneNamespaces(Collection<IEddystoneNamespace> namespaces);
}
