package com.kontakt.sdk.android.ble.discovery.ibeacon;

import com.kontakt.sdk.android.ble.device.BeaconRegion;
import com.kontakt.sdk.android.ble.discovery.Validator;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import java.util.UUID;

final class RegionValidator implements Validator<IBeaconDevice, IBeaconRegion> {

  @Override
  public boolean isValid(IBeaconDevice iBeaconDevice, IBeaconRegion iBeaconRegion) {
    if (iBeaconRegion == BeaconRegion.EVERYWHERE) {
      return true;
    }

    UUID deviceUUID = iBeaconDevice.getProximityUUID();
    if (iBeaconRegion.getSecureProximity() != null && deviceUUID.equals(iBeaconRegion.getSecureProximity())) {
      return true;
    }

    if (deviceUUID.equals(iBeaconRegion.getProximity()) && iBeaconRegion.getSecureProximity() == null) {

      if (iBeaconRegion.getMajor() != BeaconRegion.ANY_MAJOR && iBeaconRegion.getMinor() != BeaconRegion.ANY_MINOR) {
        return iBeaconDevice.getMajor() == iBeaconRegion.getMajor() && iBeaconDevice.getMinor() == iBeaconRegion.getMinor();
      }

      if (iBeaconRegion.getMajor() == BeaconRegion.ANY_MAJOR && iBeaconRegion.getMinor() != BeaconRegion.ANY_MINOR) {
        return iBeaconDevice.getMinor() == iBeaconRegion.getMinor();
      }

      if (iBeaconRegion.getMajor() != BeaconRegion.ANY_MAJOR && iBeaconRegion.getMinor() == BeaconRegion.ANY_MINOR) {
        return iBeaconDevice.getMajor() == iBeaconRegion.getMajor();
      }

      if (iBeaconRegion.getMajor() == BeaconRegion.ANY_MAJOR && iBeaconRegion.getMinor() == BeaconRegion.ANY_MINOR) {
        return true;
      }
    }

    return false;
  }
}
