package com.kontakt.sdk.android.ble.discovery;

import android.bluetooth.BluetoothDevice;
import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;

/**
 * A contract interface of Bluetooth device discoverer implemented by every
 * Remote device discoverer supported by kontakt.io Android SDK.
 */
public interface BluetoothDeviceDiscoverer {
  /**
   * Performs discovery of specific Bluetooth devices.
   *
   * @param bluetoothDevice the bluetooth device
   * @param rssi the rssi
   * @param scanResult scan result
   * @return true if discovery performs successfully
   */
  boolean performDiscovery(BluetoothDevice bluetoothDevice, int rssi, byte[] scanResult);

  /**
   * Disables discoverer.
   */
  void disable();

  /**
   * Evicts inactive devices. The device undergoes eviction
   * if Android device has not received signal from the remote device
   * for the time period specified by {@link ActivityCheckConfiguration#getInactivityTimeout()}
   *
   * @param currentTimeMillis current system time millis
   */
  void evictInactiveDevices(long currentTimeMillis);
}
