package com.kontakt.sdk.android.ble.connection;

import com.kontakt.sdk.android.cloud.IKontaktCloud;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.response.CloudError;
import com.kontakt.sdk.android.cloud.response.CloudHeaders;
import com.kontakt.sdk.android.cloud.response.paginated.Configs;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

class InternalSecureBeaconWriteListener implements WriteListener {

  final SyncableKontaktDeviceConnection.SyncWriteListener syncWriteListener;
  private final IKontaktCloud kontaktCloud;
  private final String uniqueId;

  public InternalSecureBeaconWriteListener(SyncableKontaktDeviceConnection.SyncWriteListener syncWriteListener, IKontaktCloud kontaktCloud,
      String uniqueId) {
    SDKPreconditions.checkNotNullOrEmpty(uniqueId, "unique ID is null or empty");
    this.syncWriteListener = syncWriteListener;
    this.kontaktCloud = kontaktCloud;
    this.uniqueId = uniqueId;
  }

  @Override
  public void onWriteSuccess(final WriteResponse response) {
    final Config secureConfig =
        new Config.Builder().uniqueId(uniqueId).secureResponse(response.getExtra()).secureResponseTime(response.getUnixTimestamp()).build();

    kontaktCloud.devices().applySecureConfigs(secureConfig).execute(new CloudCallback<Configs>() {
      @Override
      public void onSuccess(Configs response, CloudHeaders headers) {
        syncWriteListener.onSuccess();
      }

      @Override
      public void onError(CloudError error) {
        syncWriteListener.onSyncFailed(error, secureConfig);
      }
    });
  }

  @Override
  public void onWriteFailure(Cause cause) {
    if (syncWriteListener != null) {
      syncWriteListener.onWriteFailed(cause);
    }
  }
}
