package com.kontakt.sdk.android.ble.connection;

import com.kontakt.sdk.android.cloud.IKontaktCloud;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.response.CloudError;
import com.kontakt.sdk.android.cloud.response.CloudHeaders;
import com.kontakt.sdk.android.common.model.Device;

class InternalBeaconWriteListener implements WriteListener {

  SyncableKontaktDeviceConnection.SyncWriteListener syncWriteListener;
  private Device device;
  private IKontaktCloud kontaktCloud;

  public InternalBeaconWriteListener(IKontaktCloud kontaktCloud,
      SyncableKontaktDeviceConnection.SyncWriteListener syncWriteListener, Device device) {
    this.kontaktCloud = kontaktCloud;
    this.syncWriteListener = syncWriteListener;
    this.device = device;
  }

  @Override
  public void onWriteSuccess(WriteResponse response) {
    if (device == null) {
      int errorCode = SyncableKontaktDeviceConnection.SyncWriteListener.SYNC_NOT_IMPLEMENTED_YET;
      syncWriteListener.onSyncFailed(new KontaktCloudException("cannot update device - empty data", errorCode));
      return;
    }
    kontaktCloud.devices().update(device.getUniqueId()).with(device).execute(new CloudCallback<String>() {
      @Override
      public void onSuccess(String response, CloudHeaders headers) {
        syncWriteListener.onSuccess();
      }

      @Override
      public void onError(CloudError error) {
        syncWriteListener.onSyncFailed(error);
      }
    });
  }

  @Override
  public void onWriteFailure(Cause cause) {
    //onWriteFailureCheck(syncWriteListener, cause);
    if (syncWriteListener != null) {
      syncWriteListener.onWriteFailed(cause);
    }
  }
}
