package com.kontakt.sdk.android.ble.connection;

import com.kontakt.sdk.android.ble.dfu.FirmwareUpdateListener;
import com.kontakt.sdk.android.cloud.IKontaktCloud;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.model.Firmware;
import com.kontakt.sdk.android.common.model.Preset;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import java.util.UUID;

public interface IKontaktDeviceConnection {

  void applyConfig(Config config, WriteBatchListener<Config> writeBatchListener);

  void acceptProfile(Preset profile, WriteBatchListener<Preset> writeBatchListener);

  void overwriteMinor(int value, WriteListener writeListener);

  void enableNonConnectableMode(String masterPassword, WriteListener writeListener);

  void overwriteMajor(int value, WriteListener writeListener);

  void overwriteProximityUUID(UUID proximity, WriteListener writeListener);

  void overwritePassword(String newPassword, WriteListener writeListener);

  void overwriteModelName(String newModelName, WriteListener writeListener);

  void overwriteAdvertisingInterval(long millis, WriteListener writeListener);

  void overwritePowerLevel(int powerLevel, WriteListener writeListener);

  void switchToDeviceProfile(DeviceProfile deviceProfile, WriteListener writeListener);

  void resetDevice(WriteListener writeListener);

  void enableDfuMode(String masterPassword, WriteListener writeListener);

  void overwriteUrl(String newUrl, WriteListener writeListener);

  void overwriteNamespaceId(String namespaceId, WriteListener writeListener);

  void overwriteInstanceId(String instanceId, WriteListener writeListener);

  void restoreDefaultSettings(String masterPassword, WriteListener writeListener);

  void applySecureConfig(String secureConfig, WriteListener writeListener);

  void executeSecureCommand(String secureCommand, WriteListener writeListener);

  void updateFirmware(Firmware firmware, IKontaktCloud kontaktCloud, FirmwareUpdateListener firmwareUpdateListener);

  void updateFirmware(Firmware firmware, byte[] fileBytes, IKontaktCloud kontaktCloud, FirmwareUpdateListener firmwareUpdateListener);

  RemoteBluetoothDevice getDevice();

  boolean connect();

  boolean connect(RemoteBluetoothDevice remoteBluetoothDevice);

  boolean isConnected();

  boolean isAuthenticated();

  void close();

  boolean isClosed();

  interface ConnectionListener {
    /**
     * Called when Android Device established connection with beacon.
     */
    void onConnectionOpened();

    /**
     * Called when Beacon device was successfully authenticated and returned
     * requested characteristics
     * ({@link com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice.Characteristics})
     *
     * @param characteristics beacon characteristics
     */
    void onAuthenticationSuccess(RemoteBluetoothDevice.Characteristics characteristics);

    /**
     * Called when the authorization password sent to beacon is incorrect.
     * After unsuccessful authorization Beacon will change its state to
     * Non-connectable mode. During this mode(for about 20 minutes),
     * obtaining Beacon device characteristics will be impossible.
     *
     * @param failureCode the failure code indicating what caused authentication
     * failure.
     */
    void onAuthenticationFailure(int failureCode);

    /**
     * Called when Beacon any characteristic was succesfully changed.
     *
     * @param characteristics the characteristics
     */
    void onCharacteristicsUpdated(RemoteBluetoothDevice.Characteristics characteristics);

    /**
     * Called when unexpected error occured during interacting with Beacon device.
     *
     * @param errorCode the error code
     */
    void onErrorOccured(int errorCode);

    /**
     * Called when Android device is disconnected from remote device.
     */
    void onDisconnected();
  }
}
