/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.util;

import com.kontakt.sdk.android.common.util.SDKPreconditions;

public abstract class SDKOptional<T> {
    private static final Absent<Object> ABSENT_INSTANCE = new Absent();

    public abstract boolean isPresent();

    public abstract T get();

    public static <T> SDKOptional<T> of(T object) {
        SDKPreconditions.checkNotNull("Object is null.");
        return new Present<T>(object);
    }

    public static <T> SDKOptional<T> absent() {
        return ABSENT_INSTANCE;
    }

    private static class Absent<T>
    extends SDKOptional<T> {
        private Absent() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public T get() {
            throw new IllegalStateException("Object is absent.");
        }
    }

    private static class Present<T>
    extends SDKOptional<T> {
        private final T object;

        public Present(T object) {
            this.object = object;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public T get() {
            return this.object;
        }
    }
}

