/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.channels.Channel;

public final class Closeables {
    private Closeables() {
    }

    public static void close(Closeable closeable, boolean swallowIOException) throws IOException {
        block3: {
            if (closeable == null) {
                return;
            }
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (swallowIOException) break block3;
                throw e;
            }
        }
    }

    public static void closeQuietly(InputStream inputStream) {
        try {
            Closeables.close(inputStream, true);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    public static void closeQuietly(OutputStream outputStream) {
        try {
            Closeables.close(outputStream, true);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    public static void close(Channel channel, boolean swallowIOException) throws IOException {
        block3: {
            if (channel == null) {
                return;
            }
            try {
                channel.close();
            }
            catch (IOException e) {
                if (swallowIOException) break block3;
                throw e;
            }
        }
    }

    public static void closeQuietly(Channel channel) {
        try {
            Closeables.close(channel, false);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void closeQuietly(Reader reader) {
        try {
            Closeables.close(reader, true);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }
}

