/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.devices;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.DevicesService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class AssignDeviceRequestExecutor
extends RequestExecutor<String> {
    private final DevicesService devicesService;
    private UUID venueId;
    private UUID managerId;
    private UUID[] deviceIds;
    private String[] uniqueIds;

    public AssignDeviceRequestExecutor(DevicesService devicesService, UUID ... deviceIds) {
        this.devicesService = devicesService;
        this.deviceIds = deviceIds;
    }

    public AssignDeviceRequestExecutor(DevicesService devicesService, String ... uniqueIds) {
        this.devicesService = devicesService;
        this.uniqueIds = uniqueIds;
    }

    public AssignDeviceRequestExecutor toVenue(UUID venueId) {
        SDKPreconditions.checkNotNull(venueId, "venue ID cannot be null");
        SDKPreconditions.checkState(this.managerId == null, "toVenue cannot be used with toManager");
        this.venueId = venueId;
        return this;
    }

    public AssignDeviceRequestExecutor toManager(UUID managerId) {
        SDKPreconditions.checkNotNull(managerId, "manager ID cannot be null");
        SDKPreconditions.checkState(this.venueId == null, "toManager cannot be used with toVenue");
        this.managerId = managerId;
        return this;
    }

    @Override
    public String execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (String)super.execute();
    }

    @Override
    public void execute(CloudCallback<String> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<String> prepareCall() {
        return this.devicesService.assignDevice(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.venueId != null || this.managerId != null, "cannot assign device - specify venue or manager");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.venueId != null) {
            params.put("venueId", this.venueId.toString());
        }
        if (this.managerId != null) {
            params.put("managerId", this.managerId.toString());
        }
        if (this.deviceIds != null) {
            params.put("deviceId", StringUtils.join(this.deviceIds, ","));
        }
        if (this.uniqueIds != null) {
            params.put("uniqueId", StringUtils.join(this.uniqueIds, ","));
        }
        return params;
    }
}

