/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kontakt.sdk.android.cloud.IKontaktCloud;
import com.kontakt.sdk.android.cloud.ServicesFactory;
import com.kontakt.sdk.android.cloud.adapter.ActionTypeAdapter;
import com.kontakt.sdk.android.cloud.adapter.ConfigTypeAdapter;
import com.kontakt.sdk.android.cloud.adapter.DeviceTypeAdapter;
import com.kontakt.sdk.android.cloud.api.ActionsApi;
import com.kontakt.sdk.android.cloud.api.CommandsApi;
import com.kontakt.sdk.android.cloud.api.ConfigsApi;
import com.kontakt.sdk.android.cloud.api.DevicesApi;
import com.kontakt.sdk.android.cloud.api.EventsApi;
import com.kontakt.sdk.android.cloud.api.FirmwaresApi;
import com.kontakt.sdk.android.cloud.api.ManagersApi;
import com.kontakt.sdk.android.cloud.api.NamespacesApi;
import com.kontakt.sdk.android.cloud.api.NotificationsApi;
import com.kontakt.sdk.android.cloud.api.PresetsApi;
import com.kontakt.sdk.android.cloud.api.ProximitiesApi;
import com.kontakt.sdk.android.cloud.api.VenuesApi;
import com.kontakt.sdk.android.cloud.api.service.ActionsService;
import com.kontakt.sdk.android.cloud.api.service.CommandsService;
import com.kontakt.sdk.android.cloud.api.service.ConfigsService;
import com.kontakt.sdk.android.cloud.api.service.DevicesService;
import com.kontakt.sdk.android.cloud.api.service.EventsService;
import com.kontakt.sdk.android.cloud.api.service.FirmwaresService;
import com.kontakt.sdk.android.cloud.api.service.ManagersService;
import com.kontakt.sdk.android.cloud.api.service.NamespacesService;
import com.kontakt.sdk.android.cloud.api.service.NotificationsService;
import com.kontakt.sdk.android.cloud.api.service.PresetsService;
import com.kontakt.sdk.android.cloud.api.service.ProximitiesService;
import com.kontakt.sdk.android.cloud.api.service.VenuesService;
import com.kontakt.sdk.android.cloud.util.ErrorUtils;
import com.kontakt.sdk.android.common.KontaktSDK;
import com.kontakt.sdk.android.common.model.Action;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.model.Device;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class KontaktCloud
implements IKontaktCloud {
    public static final String API_URL = "https://api.kontakt.io";
    public static final int API_VERSION = 9;
    private final ServicesFactory servicesFactory;

    public static KontaktCloud newInstance() {
        return new KontaktCloud(KontaktSDK.getInstance().getApiKey(), API_URL, 9);
    }

    public static KontaktCloud newInstance(String apiKey) {
        return new KontaktCloud(apiKey, API_URL, 9);
    }

    private KontaktCloud(String apiKey, String apiUrl, int apiVersion) {
        SDKPreconditions.checkNotNullOrEmpty(apiKey, "Kontakt Cloud - empty api key.");
        SDKPreconditions.checkNotNullOrEmpty(apiUrl, "Kontakt Cloud - empty api url.");
        Retrofit retrofit = this.buildRetrofit(apiUrl, this.buildHttpClient(apiKey, apiVersion));
        this.servicesFactory = ServicesFactory.newInstance(retrofit);
        ErrorUtils.initialize(retrofit);
    }

    @Override
    public ActionsApi actions() {
        return new ActionsApi(this.servicesFactory.createService(ActionsService.class));
    }

    @Override
    public DevicesApi devices() {
        return new DevicesApi(this.servicesFactory.createService(DevicesService.class));
    }

    @Override
    public VenuesApi venues() {
        return new VenuesApi(this.servicesFactory.createService(VenuesService.class));
    }

    @Override
    public ConfigsApi configs() {
        return new ConfigsApi(this.servicesFactory.createService(ConfigsService.class));
    }

    @Override
    public ManagersApi managers() {
        return new ManagersApi(this.servicesFactory.createService(ManagersService.class));
    }

    @Override
    public FirmwaresApi firmwares() {
        return new FirmwaresApi(this.servicesFactory.createService(FirmwaresService.class));
    }

    @Override
    public ProximitiesApi proximities() {
        return new ProximitiesApi(this.servicesFactory.createService(ProximitiesService.class));
    }

    @Override
    public NamespacesApi namespaces() {
        return new NamespacesApi(this.servicesFactory.createService(NamespacesService.class));
    }

    @Override
    public CommandsApi commands() {
        return new CommandsApi(this.servicesFactory.createService(CommandsService.class));
    }

    @Override
    public EventsApi events() {
        return new EventsApi(this.servicesFactory.createService(EventsService.class));
    }

    @Override
    public PresetsApi presets() {
        return new PresetsApi(this.servicesFactory.createService(PresetsService.class));
    }

    private NotificationsApi notificationsApi() {
        return new NotificationsApi(this.servicesFactory.createService(NotificationsService.class));
    }

    private Retrofit buildRetrofit(String apiBaseUrl, OkHttpClient okHttpClient) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Device.class, (Object)new DeviceTypeAdapter());
        gsonBuilder.registerTypeAdapter(Config.class, (Object)new ConfigTypeAdapter());
        gsonBuilder.registerTypeAdapter(Action.class, (Object)new ActionTypeAdapter());
        gsonBuilder.setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(apiBaseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).client(okHttpClient);
        return retrofitBuilder.build();
    }

    private OkHttpClient buildHttpClient(final String apiKey, final int apiVersion) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request original = chain.request();
                Request.Builder requestBuilder = original.newBuilder().header("Accept", "application/vnd.com.kontakt+json;version=" + apiVersion).header("Api-Key", apiKey).method(original.method(), original.body());
                Request request = requestBuilder.build();
                return chain.proceed(request);
            }
        });
        return builder.build();
    }
}

