/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.spec;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;

public class Telemetry
implements Parcelable {
    public static final Parcelable.Creator<Telemetry> CREATOR = new Parcelable.Creator<Telemetry>(){

        public Telemetry createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle();
            return new Builder().setVersion(bundle.getInt("version")).setPduCount(bundle.getInt("pdu_count")).setTimeSincePowerUp(bundle.getInt("time_since_power_up")).setBatteryVoltage(bundle.getInt("battery_voltage")).setTemperature(bundle.getDouble("temperature")).build();
        }

        public Telemetry[] newArray(int size) {
            return new Telemetry[size];
        }
    };
    private final int batteryVoltage;
    private final double temperature;
    private final int pduCount;
    private final int timeSincePowerUp;
    private final int version;
    private final HashCodeBuilder hashCodeBuilder;

    public Telemetry(Builder builder) {
        this.batteryVoltage = builder.batteryVoltage;
        this.temperature = builder.temperature;
        this.pduCount = builder.pduCount;
        this.timeSincePowerUp = builder.timeSincePowerUp;
        this.version = builder.version;
        this.hashCodeBuilder = HashCodeBuilder.init();
    }

    public int getBatteryVoltage() {
        return this.batteryVoltage;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public int getPduCount() {
        return this.pduCount;
    }

    public int getTimeSincePowerUp() {
        return this.timeSincePowerUp;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Telemetry)) {
            return false;
        }
        Telemetry telemetry = (Telemetry)o;
        return this.batteryVoltage == telemetry.batteryVoltage && this.pduCount == telemetry.pduCount && this.temperature == telemetry.temperature && this.timeSincePowerUp == telemetry.timeSincePowerUp && this.version == telemetry.version;
    }

    public int hashCode() {
        return this.hashCodeBuilder.append(this.batteryVoltage).append(this.temperature).append(this.pduCount).append(this.timeSincePowerUp).append(this.version).build();
    }

    public String toString() {
        return "Telemetry{batteryVoltage=" + this.batteryVoltage + ", temperature=" + this.temperature + ", pduCount=" + this.pduCount + ", timeSincePowerUp=" + this.timeSincePowerUp + ", version=" + this.version + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle();
        bundle.putInt("battery_voltage", this.batteryVoltage);
        bundle.putDouble("temperature", this.temperature);
        bundle.putInt("pdu_count", this.pduCount);
        bundle.putInt("time_since_power_up", this.timeSincePowerUp);
        bundle.putInt("version", this.version);
        dest.writeBundle(bundle);
    }

    public static class Builder {
        int batteryVoltage;
        double temperature;
        int pduCount;
        int timeSincePowerUp;
        int version;

        public Builder setBatteryVoltage(int batteryVoltage) {
            this.batteryVoltage = batteryVoltage;
            return this;
        }

        public Builder setTemperature(double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder setPduCount(int pduCount) {
            this.pduCount = pduCount;
            return this;
        }

        public Builder setTimeSincePowerUp(int timeSincePowerUp) {
            this.timeSincePowerUp = timeSincePowerUp;
            return this;
        }

        public Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        public Telemetry build() {
            return new Telemetry(this);
        }
    }
}

