/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanPeriod;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.ble.service.BleScanCallback;
import com.kontakt.sdk.android.ble.service.Callbacks;
import com.kontakt.sdk.android.ble.service.DefaultBluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.common.KontaktSDK;
import com.kontakt.sdk.android.common.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

abstract class MonitorCallback
implements BleScanCallback,
DiscoveryContract {
    protected final BluetoothDeviceDiscoverer bluetoothDeviceDiscoverer;
    private final Handler handler = new Handler();
    private final Map<Integer, InternalProximityListener> monitoringListenerMap;
    private final ActivityCheckConfiguration activityCheckConfiguration;
    private final ScanPeriod scanPeriod;
    private final Runnable periodicActivityCheckRunnable = new Runnable(){

        @Override
        public void run() {
            MonitorCallback.this.evictInactiveDevices(System.currentTimeMillis());
        }
    };

    MonitorCallback(Callbacks.Configuration configuration) {
        this.bluetoothDeviceDiscoverer = new DefaultBluetoothDeviceDiscoverer(configuration.scanContext, this);
        this.monitoringListenerMap = new ConcurrentHashMap<Integer, InternalProximityListener>();
        this.activityCheckConfiguration = configuration.scanContext.getActivityCheckConfiguration();
        this.scanPeriod = configuration.scanContext.getScanPeriod();
        this.addRegisteredListeners(configuration);
    }

    public void onLeScan(final BluetoothDevice device, final int rssi, final byte[] scanRecord) {
        if (!this.isAnyListenerRegistered() && KontaktSDK.isInitialized()) {
            return;
        }
        if (device == null) {
            Logger.d("Remote device discovered but is null");
            return;
        }
        Logger.d(String.format("Device discovered %s", device.toString()));
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                MonitorCallback.this.bluetoothDeviceDiscoverer.performDiscovery(device, rssi, scanRecord);
            }
        });
    }

    @Override
    public void close() {
        this.bluetoothDeviceDiscoverer.disable();
        this.monitoringListenerMap.clear();
        this.handler.removeCallbacksAndMessages(null);
    }

    @Override
    public Collection<InternalProximityListener> getMonitoringListeners() {
        return Collections.unmodifiableCollection(new ArrayList<InternalProximityListener>(this.monitoringListenerMap.values()));
    }

    @Override
    public void addListener(InternalProximityListener proximityListener) {
        int hashCode = System.identityHashCode(proximityListener);
        InternalProximityListener insertion = this.monitoringListenerMap.put(hashCode, proximityListener);
        if (insertion == null) {
            Logger.d("MonitoringListener registered: " + hashCode);
        }
    }

    @Override
    public void removeListener(InternalProximityListener proximityListener) {
        int hashCode = System.identityHashCode(proximityListener);
        InternalProximityListener deletion = this.monitoringListenerMap.remove(hashCode);
        if (deletion != null) {
            Logger.d("MonitoringListener unregistered: " + hashCode);
        }
    }

    @Override
    public void onMonitorCycleStart() {
        if (this.scanPeriod != ScanPeriod.RANGING) {
            for (InternalProximityListener proximityListener : this.monitoringListenerMap.values()) {
                proximityListener.onMonitoringCycleStart();
            }
        }
        this.startPeriodicInactivityCheck();
    }

    @Override
    public void onMonitorCycleStop() {
        if (this.scanPeriod != ScanPeriod.RANGING) {
            for (InternalProximityListener proximityListener : this.monitoringListenerMap.values()) {
                proximityListener.onMonitoringCycleStop();
            }
        }
        this.stopPeriodicInactivityCheck();
    }

    @Override
    public void onEvent(BluetoothDeviceEvent event) {
        for (InternalProximityListener proximityListener : this.monitoringListenerMap.values()) {
            proximityListener.onEvent(event);
        }
    }

    private boolean isAnyListenerRegistered() {
        return !this.monitoringListenerMap.isEmpty();
    }

    private void addRegisteredListeners(Callbacks.Configuration configuration) {
        for (InternalProximityListener proximityListener : configuration.proximityListeners) {
            this.addListener(proximityListener);
        }
    }

    private void startPeriodicInactivityCheck() {
        if (this.activityCheckConfiguration == ActivityCheckConfiguration.DISABLED) {
            return;
        }
        long checkPeriod = this.activityCheckConfiguration.getCheckPeriod();
        this.handler.postDelayed(this.periodicActivityCheckRunnable, checkPeriod);
    }

    private void stopPeriodicInactivityCheck() {
        if (this.activityCheckConfiguration == ActivityCheckConfiguration.DISABLED) {
            return;
        }
        this.handler.removeCallbacksAndMessages((Object)this.periodicActivityCheckRunnable);
    }

    void evictInactiveDevices(long currentTimeMillis) {
        this.bluetoothDeviceDiscoverer.evictInactiveDevices(currentTimeMillis);
        this.startPeriodicInactivityCheck();
    }
}

