/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.rssi;

import com.kontakt.sdk.android.ble.rssi.RssiCalculator;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;

public final class LimitedMeanRssiCalculator
implements RssiCalculator {
    private final Map<Integer, Queue<Integer>> rssiMapLog = new WeakHashMap<Integer, Queue<Integer>>();
    private final int logSize;

    LimitedMeanRssiCalculator(int logSize) {
        this.logSize = logSize;
    }

    @Override
    public int calculateRssi(int uniqueKey, int rssi) {
        Queue<Integer> rssiQueue = this.rssiMapLog.get(uniqueKey);
        if (rssiQueue == null) {
            rssiQueue = new LinkedList<Integer>();
            this.rssiMapLog.put(uniqueKey, rssiQueue);
        }
        if (rssiQueue.size() >= this.logSize) {
            rssiQueue.poll();
        }
        rssiQueue.add(rssi);
        return this.mean(ConversionUtils.toPrimitive(rssiQueue.toArray(new Integer[rssiQueue.size()])));
    }

    @Override
    public void clear() {
        this.rssiMapLog.clear();
    }

    @Override
    public void clear(int uniqueKey) {
        this.rssiMapLog.remove(uniqueKey);
    }

    private int mean(int[] values) {
        int sum = 0;
        for (int value : values) {
            sum += value;
        }
        return sum / values.length;
    }
}

