/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.manager;

import android.content.Context;
import com.kontakt.sdk.android.ble.configuration.InternalProximityManagerConfiguration;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.connection.OnServiceReadyListener;
import com.kontakt.sdk.android.ble.manager.ProximityManagerContract;
import com.kontakt.sdk.android.ble.manager.configuration.Configuration;
import com.kontakt.sdk.android.ble.manager.configuration.FiltersConfigurator;
import com.kontakt.sdk.android.ble.manager.configuration.GeneralConfigurator;
import com.kontakt.sdk.android.ble.manager.configuration.SpacesConfigurator;
import com.kontakt.sdk.android.ble.manager.internal.EventObserver;
import com.kontakt.sdk.android.ble.manager.internal.InternalProximityManager;
import com.kontakt.sdk.android.ble.manager.listeners.EddystoneListener;
import com.kontakt.sdk.android.ble.manager.listeners.IBeaconListener;
import com.kontakt.sdk.android.ble.manager.listeners.ScanStatusListener;
import com.kontakt.sdk.android.ble.manager.listeners.SpaceListener;
import com.kontakt.sdk.android.cloud.IKontaktCloud;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class ProximityManager
implements ProximityManagerContract {
    private final Configuration configuration;
    private IBeaconListener iBeaconListener;
    private EddystoneListener eddystoneListener;
    private ScanStatusListener scanStatusListener;
    private SpaceListener spaceListener;
    private InternalProximityManager internalProximityManager;
    private ScanContext scanContext = ScanContext.DEFAULT;
    private InternalProximityManagerConfiguration internalProximityManagerConfiguration = InternalProximityManagerConfiguration.DEFAULT;

    public ProximityManager(Context context) {
        SDKPreconditions.checkNotNull(context, "Context can't be null");
        this.configuration = new Configuration(this.scanContext, this.internalProximityManagerConfiguration);
        this.internalProximityManager = new InternalProximityManager(context.getApplicationContext());
    }

    private ProximityManager(Context context, IKontaktCloud kontaktCloud) {
        SDKPreconditions.checkNotNull(context, "Context can't be null").getApplicationContext();
        SDKPreconditions.checkNotNull(kontaktCloud, "Kontakt Cloud can't be null");
        this.configuration = new Configuration(this.scanContext, this.internalProximityManagerConfiguration);
        this.internalProximityManager = new InternalProximityManager(context.getApplicationContext(), kontaktCloud, this.internalProximityManagerConfiguration);
    }

    @Override
    public void connect(OnServiceReadyListener onServiceReadyListener) {
        SDKPreconditions.checkNotNull(onServiceReadyListener, "OnServiceReadyListener can't be null.");
        if (!this.internalProximityManager.isConnected()) {
            this.internalProximityManager.connect(onServiceReadyListener);
        } else {
            onServiceReadyListener.onServiceReady();
            Logger.d("BeaconManager is already connected.");
        }
    }

    @Override
    public void disconnect() {
        this.internalProximityManager.disconnect();
    }

    @Override
    public void startScanning() {
        SDKPreconditions.checkArgument(this.internalProximityManager.isConnected(), "BeaconManager is not connected to ProximityService. Use BeaconManager.connect() before starting a scan.");
        if (!this.internalProximityManager.isScanning()) {
            this.createScanConfiguration();
            this.internalProximityManager.initializeScan(this.scanContext, this.internalProximityManagerConfiguration, this.createEventObserver());
        }
    }

    @Override
    public void stopScanning() {
        if (this.internalProximityManager.isScanning()) {
            this.internalProximityManager.finishScan();
        }
    }

    @Override
    public void restartScanning() {
        if (this.internalProximityManager.isScanning()) {
            this.createScanConfiguration();
            this.internalProximityManager.restartScan(this.scanContext, this.internalProximityManagerConfiguration, this.createEventObserver());
        }
    }

    @Override
    public boolean isConnected() {
        return this.internalProximityManager.isConnected();
    }

    @Override
    public boolean isScanning() {
        return this.internalProximityManager.isScanning();
    }

    @Override
    public void setScanStatusListener(ScanStatusListener listener) {
        this.scanStatusListener = listener;
    }

    @Override
    public void setSpaceListener(SpaceListener listener) {
        this.spaceListener = listener;
    }

    @Override
    public void setIBeaconListener(IBeaconListener listener) {
        this.iBeaconListener = listener;
    }

    @Override
    public void setEddystoneListener(EddystoneListener listener) {
        this.eddystoneListener = listener;
    }

    @Override
    public GeneralConfigurator configuration() {
        return this.configuration;
    }

    @Override
    public SpacesConfigurator spaces() {
        return this.configuration;
    }

    @Override
    public FiltersConfigurator filters() {
        return this.configuration;
    }

    private void createScanConfiguration() {
        this.checkObservedProfiles();
        this.scanContext = this.configuration.createScanContext();
        this.internalProximityManagerConfiguration = this.configuration.createKontaktManagerConfiguration();
    }

    private void checkObservedProfiles() {
        if (this.iBeaconListener == null) {
            this.configuration.removeObservedProfiles(DeviceProfile.IBEACON);
        } else {
            this.configuration.addObservedProfiles(DeviceProfile.IBEACON);
        }
        if (this.eddystoneListener == null) {
            this.configuration.removeObservedProfiles(DeviceProfile.EDDYSTONE);
        } else {
            this.configuration.addObservedProfiles(DeviceProfile.EDDYSTONE);
        }
    }

    private EventObserver createEventObserver() {
        return new EventObserver(this.eddystoneListener, this.iBeaconListener, this.scanStatusListener, this.spaceListener);
    }
}

