/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.filter.eddystone;

import com.kontakt.sdk.android.ble.filter.eddystone.EddystoneFilter;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public final class EddystoneFilters {
    private EddystoneFilters() {
    }

    public static EddystoneFilter newUIDFilter(final String namespace, final String instanceId) {
        SDKPreconditions.checkNotNull(namespace, "Namespace Id is null");
        SDKPreconditions.checkNotNull(instanceId, "Instance Id is null");
        return new EddystoneFilter(){

            public boolean apply(IEddystoneDevice eddystoneDevice) {
                return namespace.equals(eddystoneDevice.getNamespace()) && instanceId.equals(eddystoneDevice.getInstanceId());
            }
        };
    }

    public static EddystoneFilter newURLFilter(final String url) {
        SDKPreconditions.checkNotNull(url, "URL is null");
        return new EddystoneFilter(){

            public boolean apply(IEddystoneDevice eddystoneDevice) {
                return url.equals(eddystoneDevice.getUrl());
            }
        };
    }

    public static EddystoneFilter newNamespaceFilter(final String namespace) {
        SDKPreconditions.checkNotNull(namespace, "Namespace id is null");
        return new EddystoneFilter(){

            public boolean apply(IEddystoneDevice eddystoneDevice) {
                return namespace.equals(eddystoneDevice.getNamespace());
            }
        };
    }

    public static EddystoneFilter newInstanceIdFilter(final String instanceId) {
        SDKPreconditions.checkNotNull(instanceId, "Instance id is null");
        return new EddystoneFilter(){

            public boolean apply(IEddystoneDevice eddystoneDevice) {
                return instanceId.equals(eddystoneDevice.getInstanceId());
            }
        };
    }
}

