/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.ibeacon;

import android.bluetooth.BluetoothDevice;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.device.BeaconDevice;
import com.kontakt.sdk.android.ble.discovery.DiscoveryUtils;
import com.kontakt.sdk.android.ble.discovery.FrameDataType;
import com.kontakt.sdk.android.ble.discovery.Parser;
import com.kontakt.sdk.android.ble.discovery.ScanResponse;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconFilter;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;

public final class IBeaconParser
extends Parser<BeaconDevice> {
    public static final byte[] MANUFACTURER_DATA_IBEACON_PREFIX = new byte[]{76, 0, 2, 21};
    private static final int MANUFACTURER_DATA_IBEACON_LENGTH = 25;
    private final Collection<IBeaconFilter> filters;

    public IBeaconParser(ScanContext scanContext) {
        super(scanContext);
        this.filters = scanContext.getIBeaconFilters();
    }

    public boolean isValidIBeaconFrame(byte[] scanRecord) {
        return ConversionUtils.doesArrayContainSubset(scanRecord, MANUFACTURER_DATA_IBEACON_PREFIX, 5);
    }

    public void parseScanRecord(byte[] scanRecord) {
        this.frameData.clear();
        this.extractFrameData(scanRecord, this.frameData);
    }

    public boolean isManufacturerDataValid() {
        byte[] manufacturerData = (byte[])this.frameData.get((Object)FrameDataType.IBEACON_MANUFACTURER_SPECIFIC_DATA);
        return manufacturerData != null && manufacturerData.length == 25;
    }

    public boolean isScanResponsePresent() {
        byte[] scanResponseServiceData = (byte[])this.frameData.get((Object)FrameDataType.SCAN_RESPONSE_SERVICE_DATA);
        return scanResponseServiceData != null && ScanResponse.isValidKontaktScanResponse(scanResponseServiceData);
    }

    public IBeaconDevice getIBeaconDevice(BluetoothDevice device, int rssi) {
        int deviceHashCode = this.hashCodeBuilder.append(device.getAddress()).append((byte[])this.frameData.get((Object)FrameDataType.IBEACON_MANUFACTURER_SPECIFIC_DATA)).build();
        BeaconDevice iBeaconDevice = (BeaconDevice)this.devicesCache.get(deviceHashCode);
        if (iBeaconDevice != null) {
            this.update(iBeaconDevice, deviceHashCode, rssi);
            return new BeaconDevice.Builder(iBeaconDevice).build();
        }
        byte[] manufacturerData = (byte[])this.frameData.get((Object)FrameDataType.IBEACON_MANUFACTURER_SPECIFIC_DATA);
        byte[] serviceData = (byte[])this.frameData.get((Object)FrameDataType.SCAN_RESPONSE_SERVICE_DATA);
        ScanResponse scanResponse = ScanResponse.fromScanResponseBytes(serviceData);
        UUID proximityUUID = ConversionUtils.toUUID(Arrays.copyOfRange(manufacturerData, 4, 20));
        int major = ConversionUtils.asInt(Arrays.copyOfRange(manufacturerData, 20, 22));
        int minor = ConversionUtils.asInt(Arrays.copyOfRange(manufacturerData, 22, 24));
        int calculatedRssi = this.rssiCalculator.calculateRssi(deviceHashCode, rssi);
        byte txPower = manufacturerData[24];
        double distance = DiscoveryUtils.calculateDistance(txPower, calculatedRssi, DeviceProfile.IBEACON);
        iBeaconDevice = new BeaconDevice.Builder().setAddress(device.getAddress()).setUniqueId(scanResponse.getUniqueId()).setBatteryPower(scanResponse.getBatteryPower()).setFirmwareVersion(scanResponse.getFirmwareVersion()).setShuffled(scanResponse.isShuffled()).setName(device.getName()).setProximityUUID(proximityUUID).setMajor(major).setMinor(minor).setDistance(distance).setProximity(Proximity.fromDistance(distance)).setTxPower(txPower).setTimestamp(System.currentTimeMillis()).setRssi(calculatedRssi).build();
        this.devicesCache.put(deviceHashCode, iBeaconDevice);
        return new BeaconDevice.Builder(iBeaconDevice).build();
    }

    public boolean filter(IBeaconDevice device) {
        if (this.filters.isEmpty()) {
            return true;
        }
        for (IBeaconFilter filter : this.filters) {
            if (!filter.apply(device)) continue;
            return true;
        }
        return false;
    }

    private void update(BeaconDevice device, int deviceHashCode, int rssi) {
        int calculatedRssi = this.rssiCalculator.calculateRssi(deviceHashCode, rssi);
        byte txPower = ((byte[])this.frameData.get((Object)FrameDataType.IBEACON_MANUFACTURER_SPECIFIC_DATA))[24];
        double distance = DiscoveryUtils.calculateDistance(txPower, calculatedRssi, DeviceProfile.IBEACON);
        device.setDistance(distance);
        device.setRssi(calculatedRssi);
        device.setProximity(Proximity.fromDistance(distance));
        device.setTimestamp(System.currentTimeMillis());
    }

    @Override
    protected void disable() {
        if (this.isEnabled) {
            this.isEnabled = false;
            this.filters.clear();
            this.devicesCache.clear();
            this.rssiCalculator.clear();
        }
    }
}

