/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.ibeacon;

import android.bluetooth.BluetoothDevice;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.discovery.AbstractBluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.ble.discovery.Validator;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconParser;
import com.kontakt.sdk.android.ble.discovery.ibeacon.RegionValidator;
import com.kontakt.sdk.android.ble.util.ReplacingArrayList;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import java.util.List;

public class IBeaconDiscoverer
extends AbstractBluetoothDeviceDiscoverer<IBeaconRegion, IBeaconDevice> {
    private final IBeaconParser parser;
    private final Validator<IBeaconDevice, IBeaconRegion> validator;

    public IBeaconDiscoverer(ScanContext scanContext, DiscoveryContract discoveryContract) {
        super(discoveryContract, scanContext.getActivityCheckConfiguration(), scanContext.getIBeaconRegions(), scanContext.getDevicesUpdateCallbackInterval(), scanContext.isNonConnectableModeSupported());
        this.parser = new IBeaconParser(scanContext);
        this.validator = new RegionValidator();
    }

    @Override
    protected BluetoothDeviceEvent createEvent(EventType eventType, IBeaconRegion iBeaconRegion, List<IBeaconDevice> deviceList) {
        return new IBeaconDeviceEvent(eventType, iBeaconRegion, deviceList);
    }

    @Override
    protected void onBeforeDeviceLost(IBeaconDevice device) {
        this.parser.clearRssiCalculation(device.hashCode());
    }

    @Override
    public boolean performDiscovery(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (!this.parser.isEnabled() || !this.parser.isValidIBeaconFrame(scanRecord)) {
            return PROFILE_UNRECOGNIZED;
        }
        this.parser.parseScanRecord(scanRecord);
        if (this.parser.getFrameData().size() == 0 || !this.parser.isManufacturerDataValid()) {
            return PROFILE_UNRECOGNIZED;
        }
        if (!this.isNonConnectableModeSupported && !this.parser.isScanResponsePresent()) {
            return PROFILE_UNRECOGNIZED;
        }
        IBeaconDevice iBeaconDevice = this.parser.getIBeaconDevice(device, rssi);
        this.notifyDevicePresent(device.getAddress().hashCode(), System.currentTimeMillis());
        IBeaconRegion iBeaconRegion = this.extractRegion(iBeaconDevice);
        if (iBeaconRegion == null) {
            return PROFILE_RECOGNIZED_NO_BELONGING_SPACE_FOUND;
        }
        if (!this.parser.filter(iBeaconDevice)) {
            return PROFILE_RECOGNIZED_FILTERING_NOT_PASSED;
        }
        if (iBeaconDevice.getProximity() != Proximity.UNKNOWN) {
            this.notifySpacePresent(iBeaconRegion.hashCode(), System.currentTimeMillis());
            ReplacingArrayList<Object> iBeaconList = this.getDevicesInSpace(iBeaconRegion);
            if (iBeaconList == null) {
                iBeaconList = new ReplacingArrayList();
                this.insertDevicesIntoSpace(iBeaconRegion, iBeaconList);
                this.onSpaceEnteredEvent(iBeaconRegion);
            }
            if (iBeaconList.addOrReplace(iBeaconDevice)) {
                this.onDeviceDiscoveredEvent(iBeaconRegion, iBeaconDevice);
            } else {
                this.onDevicesUpdatedEvent(iBeaconRegion, iBeaconList);
            }
            return true;
        }
        return false;
    }

    @Override
    public void disable() {
        this.parser.disable();
    }

    private IBeaconRegion extractRegion(IBeaconDevice iBeaconDevice) {
        for (IBeaconRegion iBeaconRegion : this.getSpaceSet()) {
            if (!this.validator.isValid(iBeaconDevice, iBeaconRegion)) continue;
            return iBeaconRegion;
        }
        return null;
    }
}

