/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.ibeacon;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.ble.device.BeaconRegion;
import com.kontakt.sdk.android.ble.discovery.AbstractBluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class IBeaconDeviceEvent
extends AbstractBluetoothDeviceEvent {
    private static final ArrayList<IBeaconDevice> EMPTY_DEVICE_LIST = new ArrayList(0);
    public static final Parcelable.Creator<IBeaconDeviceEvent> CREATOR = new Parcelable.Creator<IBeaconDeviceEvent>(){

        public IBeaconDeviceEvent createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle(this.getClass().getClassLoader());
            BeaconRegion iBeaconRegion = (BeaconRegion)bundle.getParcelable("region");
            EventType eventType = (EventType)((Object)bundle.getSerializable("kontakt_event_type"));
            ArrayList deviceList = bundle.getParcelableArrayList("remote_device_list");
            long timestamp = bundle.getLong("timestamp");
            return new IBeaconDeviceEvent(eventType, iBeaconRegion, deviceList, timestamp);
        }

        public IBeaconDeviceEvent[] newArray(int size) {
            return new IBeaconDeviceEvent[size];
        }
    };
    private final IBeaconRegion region;

    public static IBeaconDeviceEvent of(IBeaconDeviceEvent event, List<IBeaconDevice> devices) {
        return new IBeaconDeviceEvent(event.getEventType(), event.getRegion(), devices, event.getTimestamp());
    }

    public static IBeaconDeviceEvent createNewDiscovered(IBeaconDevice device, IBeaconRegion region, long timestamp) {
        ArrayList<IBeaconDevice> discovered = new ArrayList<IBeaconDevice>();
        discovered.add(device);
        return new IBeaconDeviceEvent(EventType.DEVICE_DISCOVERED, region, discovered, timestamp);
    }

    public IBeaconDeviceEvent(EventType eventType, BeaconRegion iBeaconRegion) {
        this(eventType, iBeaconRegion, EMPTY_DEVICE_LIST);
    }

    public IBeaconDeviceEvent(EventType eventType, IBeaconRegion iBeaconRegion, List<IBeaconDevice> iBeaconDeviceList) {
        this(eventType, iBeaconRegion, iBeaconDeviceList, System.currentTimeMillis());
    }

    IBeaconDeviceEvent(EventType eventType, IBeaconRegion region, List<IBeaconDevice> iBeaconDevices, long timestamp) {
        super(eventType, DeviceProfile.IBEACON, iBeaconDevices, timestamp);
        this.region = region;
    }

    public List<IBeaconDevice> getDeviceList() {
        return super.getDeviceList();
    }

    public IBeaconRegion getRegion() {
        return this.region;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putSerializable("kontakt_event_type", (Serializable)((Object)this.eventType));
        bundle.putLong("timestamp", this.timestamp);
        bundle.putParcelableArrayList("remote_device_list", (ArrayList)this.deviceList);
        bundle.putParcelable("region", (Parcelable)this.region);
        dest.writeBundle(bundle);
    }
}

