/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.device;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.KontaktSDK;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.Serializable;
import java.util.UUID;

public class BeaconRegion
implements IBeaconRegion {
    public static final Parcelable.Creator<BeaconRegion> CREATOR = new Parcelable.Creator<BeaconRegion>(){

        public BeaconRegion createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle(this.getClass().getClassLoader());
            return new Builder().setProximity((UUID)bundle.getSerializable("uuid")).setMajor(bundle.getInt("major")).setMinor(bundle.getInt("minor")).setShuffled(bundle.getBoolean("shuffled")).setIdentifier(bundle.getString("identifier")).build();
        }

        public BeaconRegion[] newArray(int size) {
            return new BeaconRegion[size];
        }
    };
    public static final int ANY_MAJOR = -1;
    public static final int ANY_MINOR = -1;
    public static final BeaconRegion EVERYWHERE = new Builder().setProximity(KontaktSDK.DEFAULT_KONTAKT_BEACON_PROXIMITY_UUID).setMajor(-1).setMinor(-1).setShuffled(false).setIdentifier("Everywhere").build();
    private final UUID proximity;
    private final int major;
    private final int minor;
    private final boolean shuffled;
    private final String identifier;
    private final int hashCode;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public UUID getProximity() {
        return this.proximity;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isShuffled() {
        return this.shuffled;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putSerializable("uuid", (Serializable)this.proximity);
        bundle.putInt("major", this.major);
        bundle.putInt("minor", this.minor);
        bundle.putBoolean("shuffled", this.shuffled);
        bundle.putString("identifier", this.identifier);
        dest.writeBundle(bundle);
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof BeaconRegion)) {
            return false;
        }
        BeaconRegion IBeaconRegion2 = (BeaconRegion)o;
        return IBeaconRegion2.getProximity().equals(this.proximity) && IBeaconRegion2.getMajor() == this.major && IBeaconRegion2.getMinor() == this.minor && IBeaconRegion2.isShuffled() == this.shuffled;
    }

    public int hashCode() {
        return this.hashCode;
    }

    BeaconRegion(Builder builder) {
        SDKPreconditions.checkNotNull(builder.proximity, "Proximity is not set");
        this.proximity = builder.proximity;
        this.major = builder.major;
        this.minor = builder.minor;
        this.shuffled = builder.shuffled;
        this.identifier = builder.identifier;
        this.hashCode = HashCodeBuilder.init().append(this.proximity).append(this.major).append(this.minor).append(this.shuffled).build();
    }

    public static class Builder {
        UUID proximity;
        int major = -1;
        int minor = -1;
        boolean shuffled;
        String identifier;

        public Builder setProximity(UUID proximity) {
            this.proximity = proximity;
            return this;
        }

        public Builder setMajor(int major) {
            this.major = major;
            return this;
        }

        public Builder setMinor(int minor) {
            this.minor = minor;
            return this;
        }

        public Builder setShuffled(boolean shuffled) {
            this.shuffled = shuffled;
            return this;
        }

        public Builder setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public BeaconRegion build() {
            return new BeaconRegion(this);
        }
    }
}

