/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import android.content.Context;
import com.kontakt.sdk.android.ble.connection.IKontaktDeviceConnection;
import com.kontakt.sdk.android.ble.connection.ISyncableKontaktDeviceConnection;
import com.kontakt.sdk.android.ble.connection.InternalBeaconWriteBatchListener;
import com.kontakt.sdk.android.ble.connection.InternalBeaconWriteListener;
import com.kontakt.sdk.android.ble.connection.InternalSecureBeaconWriteListener;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceConnection;
import com.kontakt.sdk.android.ble.connection.WriteListener;
import com.kontakt.sdk.android.cloud.IKontaktCloud;
import com.kontakt.sdk.android.cloud.KontaktCloud;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudError;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.model.Device;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import java.util.UUID;

public class SyncableKontaktDeviceConnection
implements ISyncableKontaktDeviceConnection {
    private static final DeviceType DEVICE_TYPE = DeviceType.BEACON;
    private KontaktDeviceConnection kontaktDeviceConnection;
    private IKontaktCloud kontaktCloud;

    public SyncableKontaktDeviceConnection(Context context, RemoteBluetoothDevice remoteBluetoothDevice, IKontaktDeviceConnection.ConnectionListener connectionListener) {
        this.kontaktDeviceConnection = new KontaktDeviceConnection(context, remoteBluetoothDevice, connectionListener);
        this.createKontaktCloud();
    }

    private void createKontaktCloud() {
        this.kontaktCloud = KontaktCloud.newInstance();
    }

    @Override
    public synchronized boolean connectToDevice() {
        return this.kontaktDeviceConnection.connect();
    }

    @Override
    public synchronized boolean isConnectedToDevice() {
        return this.kontaktDeviceConnection.isConnected();
    }

    @Override
    public synchronized void close() {
        this.kontaktDeviceConnection.close();
    }

    @Override
    public synchronized RemoteBluetoothDevice getDevice() {
        return this.kontaktDeviceConnection.getDevice();
    }

    @Override
    public synchronized boolean isDeviceAuthenticated() {
        return this.kontaktDeviceConnection.isAuthenticated();
    }

    @Override
    public synchronized void overwriteMinor(int value, SyncWriteListener syncWriteListener) {
        Config config = new Config.Builder().minor(value).build();
        Device device = new Device.Builder().uniqueId(this.getDeviceUniqueId()).deviceType(DEVICE_TYPE).config(config).build();
        this.kontaktDeviceConnection.overwriteMinor(value, new InternalBeaconWriteListener(this.kontaktCloud, syncWriteListener, device));
    }

    @Override
    public void overwriteMajor(int value, SyncWriteListener syncWriteListener) {
        Config config = new Config.Builder().major(value).build();
        Device device = new Device.Builder().uniqueId(this.getDeviceUniqueId()).deviceType(DEVICE_TYPE).config(config).build();
        this.kontaktDeviceConnection.overwriteMajor(value, new InternalBeaconWriteListener(this.kontaktCloud, syncWriteListener, device));
    }

    @Override
    public void overwritePowerLevel(int value, SyncWriteListener syncWriteListener) {
        Config config = new Config.Builder().txPower(value).build();
        Device device = new Device.Builder().uniqueId(this.getDeviceUniqueId()).deviceType(DEVICE_TYPE).config(config).build();
        this.kontaktDeviceConnection.overwritePowerLevel(value, new InternalBeaconWriteListener(this.kontaktCloud, syncWriteListener, device));
    }

    @Override
    public void overwriteProximityUUID(UUID proximityUUID, SyncWriteListener syncWriteListener) {
        Config config = new Config.Builder().proximity(proximityUUID).build();
        Device device = new Device.Builder().uniqueId(this.getDeviceUniqueId()).deviceType(DEVICE_TYPE).config(config).build();
        this.kontaktDeviceConnection.overwriteProximityUUID(proximityUUID, new InternalBeaconWriteListener(this.kontaktCloud, syncWriteListener, device));
    }

    @Override
    public void overwritePassword(String password, SyncWriteListener syncWriteListener) {
        Config config = new Config.Builder().password(password).build();
        Device device = new Device.Builder().uniqueId(this.getDeviceUniqueId()).deviceType(DEVICE_TYPE).config(config).build();
        this.kontaktDeviceConnection.overwritePassword(password, new InternalBeaconWriteListener(this.kontaktCloud, syncWriteListener, device));
    }

    @Override
    public void overwriteAdvertisingInterval(long interval, SyncWriteListener syncWriteListener) {
        Config config = new Config.Builder().interval((int)interval).build();
        Device device = new Device.Builder().uniqueId(this.getDeviceUniqueId()).deviceType(DEVICE_TYPE).config(config).build();
        this.kontaktDeviceConnection.overwriteAdvertisingInterval(interval, new InternalBeaconWriteListener(this.kontaktCloud, syncWriteListener, device));
    }

    @Override
    public void overwriteModelName(String modelName, SyncWriteListener syncWriteListener) {
        Config config = new Config.Builder().name(modelName).build();
        Device device = new Device.Builder().uniqueId(this.getDeviceUniqueId()).deviceType(DEVICE_TYPE).config(config).build();
        this.kontaktDeviceConnection.overwriteModelName(modelName, new InternalBeaconWriteListener(this.kontaktCloud, syncWriteListener, device));
    }

    @Override
    public void resetDevice(WriteListener writeListener) {
        this.kontaktDeviceConnection.resetDevice(writeListener);
    }

    @Override
    public void overwriteUrl(String url, SyncWriteListener syncWriteListener) {
        Config config = new Config.Builder().url(url).build();
        Device device = new Device.Builder().uniqueId(this.getDeviceUniqueId()).deviceType(DEVICE_TYPE).config(config).build();
        this.kontaktDeviceConnection.overwriteUrl(url, new InternalBeaconWriteListener(this.kontaktCloud, syncWriteListener, device));
    }

    @Override
    public void overwriteNamespace(String namespaceId, SyncWriteListener syncWriteListener) {
        Config config = new Config.Builder().namespace(namespaceId).build();
        Device device = new Device.Builder().uniqueId(this.getDeviceUniqueId()).deviceType(DEVICE_TYPE).config(config).build();
        this.kontaktDeviceConnection.overwriteNamespaceId(namespaceId, new InternalBeaconWriteListener(this.kontaktCloud, syncWriteListener, device));
    }

    @Override
    public void overwriteInstanceId(String instanceId, SyncWriteListener syncWriteListener) {
        Config config = new Config.Builder().instanceId(instanceId).build();
        Device device = new Device.Builder().uniqueId(this.getDeviceUniqueId()).deviceType(DEVICE_TYPE).config(config).build();
        this.kontaktDeviceConnection.overwriteInstanceId(instanceId, new InternalBeaconWriteListener(this.kontaktCloud, syncWriteListener, device));
    }

    @Override
    public void applyConfig(Config config, SyncWriteBatchListener<Config> syncWriteBatchListener) {
        this.kontaktDeviceConnection.applyConfig(config, new InternalBeaconWriteBatchListener<Config>(this.kontaktCloud, syncWriteBatchListener));
    }

    @Override
    public void applySecureConfig(Config secureConfig, SyncWriteListener syncWriteListener) {
        this.kontaktDeviceConnection.applySecureConfig(secureConfig.getSecureRequest(), new InternalSecureBeaconWriteListener(syncWriteListener, this.kontaktCloud, this.getDeviceUniqueId()));
    }

    private String getDeviceUniqueId() {
        return this.getDevice().getUniqueId();
    }

    public static abstract class SyncWriteBatchListener<T> {
        public void onSyncWriteBatchStart(T batchHolder) {
        }

        public void onWriteFailed() {
        }

        public void onBatchWriteError(int errorCode) {
        }

        public void onSyncFailed(KontaktCloudException e) {
        }

        public void onSyncFailed(String message, int errorCode) {
        }

        public void onSuccess(T batchHolder) {
        }
    }

    public static abstract class SyncWriteListener {
        public static final int SYNC_NOT_IMPLEMENTED_YET = -1;

        @Deprecated
        public void onWriteFailed() {
        }

        public void onWriteFailed(WriteListener.Cause cause) {
        }

        public void onSyncFailed(KontaktCloudException e) {
        }

        public void onSyncFailed(CloudError e) {
        }

        public void onSyncFailed(KontaktCloudException e, String response) {
        }

        public void onSyncFailed(CloudError e, Config secureResponse) {
        }

        public void onSuccess() {
        }
    }
}

