/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.configuration.scan;

import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanPeriod;
import com.kontakt.sdk.android.ble.configuration.scan.GlobalScanContext;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContextValidator;
import com.kontakt.sdk.android.ble.configuration.scan.ScanMode;
import com.kontakt.sdk.android.ble.device.BeaconRegion;
import com.kontakt.sdk.android.ble.device.EddystoneNamespace;
import com.kontakt.sdk.android.ble.filter.eddystone.EddystoneFilter;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconFilter;
import com.kontakt.sdk.android.ble.rssi.RssiCalculator;
import com.kontakt.sdk.android.ble.rssi.RssiCalculators;
import com.kontakt.sdk.android.ble.spec.EddystoneFrameType;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ScanContext
implements GlobalScanContext {
    public static final long DEFAULT_DEVICES_UPDATE_CALLBACK_INTERVAL = 3000L;
    public static final ScanContext DEFAULT = new Builder().build();
    private final ForceScanConfiguration forceScanConfiguration;
    private final ScanPeriod scanPeriod;
    private final ScanMode scanMode;
    private final ActivityCheckConfiguration activityCheckConfiguration;
    private final long devicesUpdateCallbackInterval;
    private final RssiCalculator rssiCalculator;
    private final boolean supportNonConnectable;
    private final Set<DeviceProfile> observedProfiles;
    private final Set<EddystoneFrameType> eddystoneTriggerFrameTypes;
    private final Set<IBeaconRegion> iBeaconRegions;
    private final Set<IEddystoneNamespace> eddystoneNamespaces;
    private final List<IBeaconFilter> iBeaconFilters;
    private final List<EddystoneFilter> eddystoneFilters;

    ScanContext(Builder builder) {
        this.forceScanConfiguration = builder.forceScanConfiguration;
        this.scanPeriod = builder.scanPeriod;
        this.scanMode = builder.scanMode;
        this.activityCheckConfiguration = builder.activityCheckConfiguration;
        this.devicesUpdateCallbackInterval = builder.devicesUpdateCallbackInterval;
        this.rssiCalculator = builder.rssiCalculator;
        this.supportNonConnectable = builder.supportNonConnectable;
        this.observedProfiles = builder.observedProfiles;
        this.eddystoneTriggerFrameTypes = builder.eddystoneTriggerFrameTypes;
        this.iBeaconRegions = builder.iBeaconRegions;
        this.eddystoneNamespaces = builder.eddystoneNamespaces;
        this.iBeaconFilters = builder.iBeaconFilters;
        this.eddystoneFilters = builder.eddystoneFilters;
    }

    @Override
    public ActivityCheckConfiguration getActivityCheckConfiguration() {
        return this.activityCheckConfiguration;
    }

    @Override
    public Set<DeviceProfile> getObservedProfiles() {
        return this.observedProfiles;
    }

    @Override
    public ForceScanConfiguration getForceScanConfiguration() {
        return this.forceScanConfiguration;
    }

    @Override
    public ScanPeriod getScanPeriod() {
        return this.scanPeriod;
    }

    @Override
    public ScanMode getScanMode() {
        return this.scanMode;
    }

    @Override
    public long getDevicesUpdateCallbackInterval() {
        return this.devicesUpdateCallbackInterval;
    }

    @Override
    public RssiCalculator getRssiCalculator() {
        return this.rssiCalculator;
    }

    @Override
    public boolean isNonConnectableModeSupported() {
        return this.supportNonConnectable;
    }

    @Override
    public Collection<EddystoneFrameType> getEddystoneFrameTypes() {
        return this.eddystoneTriggerFrameTypes;
    }

    @Override
    public Set<IBeaconRegion> getIBeaconRegions() {
        return this.iBeaconRegions;
    }

    @Override
    public Set<IEddystoneNamespace> getEddystoneNamespaces() {
        return this.eddystoneNamespaces;
    }

    @Override
    public List<IBeaconFilter> getIBeaconFilters() {
        return this.iBeaconFilters;
    }

    @Override
    public List<EddystoneFilter> getEddystoneFilters() {
        return this.eddystoneFilters;
    }

    public static final class Builder {
        boolean supportNonConnectable;
        ScanMode scanMode = ScanMode.BALANCED;
        ScanPeriod scanPeriod = ScanPeriod.RANGING;
        ForceScanConfiguration forceScanConfiguration = ForceScanConfiguration.DISABLED;
        ActivityCheckConfiguration activityCheckConfiguration = ActivityCheckConfiguration.DEFAULT;
        RssiCalculator rssiCalculator = RssiCalculators.DEFAULT;
        long devicesUpdateCallbackInterval = 3000L;
        Set<DeviceProfile> observedProfiles = EnumSet.allOf(DeviceProfile.class);
        Set<EddystoneFrameType> eddystoneTriggerFrameTypes = EnumSet.noneOf(EddystoneFrameType.class);
        Set<IBeaconRegion> iBeaconRegions = new HashSet<IBeaconRegion>();
        Set<IEddystoneNamespace> eddystoneNamespaces = new HashSet<IEddystoneNamespace>();
        List<IBeaconFilter> iBeaconFilters = new ArrayList<IBeaconFilter>();
        List<EddystoneFilter> eddystoneFilters = new ArrayList<EddystoneFilter>();

        public Builder setActivityCheckConfiguration(ActivityCheckConfiguration activityCheckConfiguration) {
            SDKPreconditions.checkNotNull(activityCheckConfiguration, "Beacon activity check is null.");
            this.activityCheckConfiguration = activityCheckConfiguration;
            return this;
        }

        public Builder setScanMode(ScanMode scanMode) {
            SDKPreconditions.checkNotNull(scanMode, "Scan mode is null");
            this.scanMode = scanMode;
            return this;
        }

        public Builder setForceScanConfiguration(ForceScanConfiguration forceScanConfiguration) {
            SDKPreconditions.checkNotNull(forceScanConfiguration, "By default ForceScanConfiguration is disabled");
            this.forceScanConfiguration = forceScanConfiguration;
            return this;
        }

        public Builder setScanPeriod(ScanPeriod scanPeriod) {
            SDKPreconditions.checkNotNull(scanPeriod, "Monitor period cannot be null");
            this.scanPeriod = scanPeriod;
            return this;
        }

        public Builder setDevicesUpdateCallbackInterval(long intervalInMillis) {
            SDKPreconditions.checkArgument(intervalInMillis > 0L, "Interval must be greater than 0");
            this.devicesUpdateCallbackInterval = intervalInMillis;
            return this;
        }

        public Builder setRssiCalculator(RssiCalculator rssiCalculator) {
            SDKPreconditions.checkNotNull(rssiCalculator, "RssiCalculator can't be null");
            this.rssiCalculator = rssiCalculator;
            return this;
        }

        public Builder setSupportNonConnectableMode(boolean enabled) {
            this.supportNonConnectable = enabled;
            return this;
        }

        public Builder setObservedProfiles(Set<DeviceProfile> observedProfiles) {
            SDKPreconditions.checkNotNull(observedProfiles, "Observed profiles can't be null");
            this.observedProfiles = observedProfiles;
            return this;
        }

        public Builder setIBeaconFilters(Collection<? extends IBeaconFilter> filters) {
            SDKPreconditions.checkNotNull(filters, "Filters are null.");
            this.iBeaconFilters.clear();
            this.iBeaconFilters.addAll(filters);
            return this;
        }

        public Builder setIBeaconRegions(Collection<IBeaconRegion> iBeaconRegions) {
            SDKPreconditions.checkNotNull(iBeaconRegions, "Regions collection is null");
            this.iBeaconRegions.clear();
            this.iBeaconRegions.addAll(iBeaconRegions);
            return this;
        }

        public Builder setEddystoneFilters(Collection<EddystoneFilter> eddystoneFilters) {
            SDKPreconditions.checkNotNull(eddystoneFilters, "Filters are null.");
            this.eddystoneFilters.clear();
            this.eddystoneFilters.addAll(eddystoneFilters);
            return this;
        }

        public Builder setEddystoneNamespaces(Collection<IEddystoneNamespace> eddystoneNamespaces) {
            SDKPreconditions.checkNotNull(eddystoneNamespaces, "Eddystone namespaces are null.");
            this.eddystoneNamespaces.clear();
            this.eddystoneNamespaces.addAll(eddystoneNamespaces);
            return this;
        }

        public Builder setRequiredEddystoneFrameTypes(Collection<EddystoneFrameType> eddystoneFrames) {
            SDKPreconditions.checkNotNull(eddystoneFrames, "Eddystone trigger frames");
            this.eddystoneTriggerFrameTypes.clear();
            this.eddystoneTriggerFrameTypes.addAll(eddystoneFrames);
            return this;
        }

        public ScanContext build() {
            SDKPreconditions.checkNotNullOrEmpty(this.observedProfiles, "At least one listener (IBeacon or Eddystone) must be set.");
            ScanContextValidator.validate(this.scanPeriod);
            ScanContextValidator.validateEddystoneFiltersCount(this.eddystoneFilters);
            ScanContextValidator.validateIBeaconFiltersCount(this.iBeaconFilters);
            ScanContextValidator.validateIBeaconRegionsCount(this.iBeaconRegions);
            ScanContextValidator.validateNamespacesCount(this.eddystoneNamespaces);
            ScanContextValidator.validate(this.activityCheckConfiguration);
            ScanContextValidator.validate(this.forceScanConfiguration);
            ScanContextValidator.validate(this.activityCheckConfiguration, this.scanPeriod);
            if (this.iBeaconRegions.isEmpty()) {
                this.iBeaconRegions.add(BeaconRegion.EVERYWHERE);
            }
            if (this.eddystoneNamespaces.isEmpty()) {
                this.eddystoneNamespaces.add(EddystoneNamespace.EVERYWHERE);
            }
            return new ScanContext(this);
        }
    }
}

