/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.cache;

import android.content.Context;
import android.util.SparseArray;
import android.util.TimingLogger;
import com.kontakt.sdk.android.ble.cache.EddystoneResolveRequest;
import com.kontakt.sdk.android.ble.cache.EddystoneUIDResolver;
import com.kontakt.sdk.android.ble.cache.IBeaconIdResolver;
import com.kontakt.sdk.android.ble.cache.IBeaconResolveRequest;
import com.kontakt.sdk.android.ble.configuration.InternalProximityManagerConfiguration;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.manager.listeners.KontaktProximityListener;
import com.kontakt.sdk.android.cloud.IKontaktCloud;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.model.EddystoneUid;
import com.kontakt.sdk.android.common.model.IBeaconId;
import com.kontakt.sdk.android.common.model.ResolvedId;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class FutureShufflesCache {
    private static final String PHANTOM_LABEL = "-PHANTOM-";
    private static final String TAG = "FSCache";
    private static final int DEFAULT_RESOLVER_POOL_SIZE = 2;
    private static final int INITIAL_IBEACON_RESOLVER_DELAY = 1;
    private static final int INITIAL_EDDYSTONE_RESOLVER_DELAY = 2;
    public static final ResolvedId PHANTOM_ENTRY = ResolvedId.create("-PHANTOM-", "-PHANTOM-", null);
    private final Map<String, ResolvedId> internalCache = new ConcurrentHashMap<String, ResolvedId>();
    private final Set<String> ignored = new ConcurrentSkipListSet<String>();
    private final IBeaconIdResolver iBeaconIdResolver;
    private final EddystoneUIDResolver eddystoneUIDResolver;
    private final SparseArray<List<KontaktProximityListener>> listenerRegister = new SparseArray();
    private final Context context;
    private final InternalProximityManagerConfiguration configuration;
    CacheState state = CacheState.INITIALIZING;
    private ScheduledExecutorService executorService;

    public FutureShufflesCache(Context context, IKontaktCloud kontaktCloud, InternalProximityManagerConfiguration configuration) {
        this.context = context;
        this.configuration = configuration;
        this.iBeaconIdResolver = new IBeaconIdResolver(this, kontaktCloud);
        this.eddystoneUIDResolver = new EddystoneUIDResolver(this, kontaktCloud);
        new DeserializerThread("cache-deserializer-thread").start();
    }

    public ResolvedId get(RemoteBluetoothDevice origin) {
        switch (origin.getProfile()) {
            case IBEACON: {
                IBeaconDevice iBeaconDevice = (IBeaconDevice)origin;
                String fakeId = IBeaconId.fromDevice(iBeaconDevice).toString();
                return this.get(fakeId);
            }
            case EDDYSTONE: {
                IEddystoneDevice eddystoneDevice = (IEddystoneDevice)origin;
                String fakeUID = EddystoneUid.fromDevice(eddystoneDevice).toString();
                return this.get(fakeUID);
            }
        }
        throw new IllegalArgumentException("Unsupported device profile!");
    }

    public ResolvedId get(String deviceId) {
        if (this.internalCache.containsKey(deviceId)) {
            return this.internalCache.get(deviceId);
        }
        if (this.ignored.contains(deviceId)) {
            return PHANTOM_ENTRY;
        }
        return null;
    }

    public void registerProximityManager(int shuffledProximityManagerId) {
        List listeners = (List)this.listenerRegister.get(shuffledProximityManagerId);
        if (listeners != null) {
            return;
        }
        this.listenerRegister.put(shuffledProximityManagerId, new LinkedList());
    }

    public void unregisterProximityManager(int shuffledProximityManagerId) {
        List listeners = (List)this.listenerRegister.get(shuffledProximityManagerId);
        if (listeners == null) {
            return;
        }
        this.listenerRegister.remove(shuffledProximityManagerId);
    }

    public void addProximityListener(KontaktProximityListener kontaktProximityListener) {
        Integer proximityManagerId = kontaktProximityListener.getParentProximityManagerId();
        List listeners = (List)this.listenerRegister.get(proximityManagerId.intValue());
        if (listeners == null) {
            throw new IllegalStateException("Kontakt proximity manager is not registered!");
        }
        this.createResolverRunners();
        listeners.add(kontaktProximityListener);
    }

    public void removeProximityListener(KontaktProximityListener kontaktProximityListener) {
        Integer proximityManagerId = kontaktProximityListener.getParentProximityManagerId();
        List listeners = (List)this.listenerRegister.get(proximityManagerId.intValue());
        if (listeners == null) {
            throw new IllegalStateException("Kontakt proximity manager is not registered!");
        }
        listeners.remove(kontaktProximityListener);
        if (listeners.isEmpty()) {
            this.finishResolveRunners();
        }
    }

    public void addResolveRequest(int proximityManagerId, BluetoothDeviceEvent event) {
        switch (event.getDeviceProfile()) {
            case IBEACON: {
                IBeaconResolveRequest iBeaconRequest = IBeaconResolveRequest.of(proximityManagerId, event);
                this.iBeaconIdResolver.addResolveRequest(iBeaconRequest);
                break;
            }
            case EDDYSTONE: {
                EddystoneResolveRequest eddystoneRequest = EddystoneResolveRequest.of(proximityManagerId, event);
                this.eddystoneUIDResolver.addResolveRequest(eddystoneRequest);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported device profile!");
            }
        }
    }

    void evict(List<String> uniqueIds, DeviceProfile deviceProfile) {
        Iterator<Map.Entry<String, ResolvedId>> cacheIterator = this.internalCache.entrySet().iterator();
        while (cacheIterator.hasNext()) {
            Map.Entry<String, ResolvedId> entry = cacheIterator.next();
            ResolvedId evictCandidate = entry.getValue();
            if (!uniqueIds.contains(evictCandidate.getUniqueId()) || deviceProfile != evictCandidate.getDeviceProfile()) continue;
            cacheIterator.remove();
        }
    }

    private void finishResolveRunners() {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }

    private void createResolverRunners() {
        if (this.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(2);
            this.executorService.scheduleWithFixedDelay(this.iBeaconIdResolver, 1L, this.configuration.getResolveInterval(), TimeUnit.SECONDS);
            this.executorService.scheduleWithFixedDelay(this.eddystoneUIDResolver, 2L, this.configuration.getResolveInterval(), TimeUnit.SECONDS);
        }
    }

    public CacheState getState() {
        return this.state;
    }

    public boolean isInitialized() {
        return CacheState.INITIALIZED == this.state;
    }

    void populate(String deviceId, ResolvedId resolvedId) {
        if (PHANTOM_ENTRY.equals(resolvedId)) {
            this.ignored.add(deviceId);
        } else {
            this.internalCache.put(deviceId, resolvedId);
        }
    }

    void notifyListeners(int proximityManagerId, BluetoothDeviceEvent event) {
        for (KontaktProximityListener listener : (List)this.listenerRegister.get(proximityManagerId)) {
            listener.onEvent(event);
        }
    }

    synchronized void serialize() {
        try {
            TimingLogger timings = new TimingLogger(TAG, "Serialization");
            FileOutputStream fos = this.context.openFileOutput(this.configuration.getCacheFileName(), 0);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            ObjectOutputStream os = new ObjectOutputStream(fos);
            os.writeObject(this.internalCache);
            os.close();
            bos.close();
            fos.close();
            Logger.d("FSCache Cached size: " + this.internalCache.size());
            timings.addSplit("save file");
            timings.dumpToLog();
        }
        catch (IOException e) {
            Logger.e("FSCache Error when try to deserialize cache: ", e);
        }
    }

    void deserialize() {
        try {
            TimingLogger timings = new TimingLogger(TAG, "Deserialization");
            FileInputStream fis = this.context.openFileInput(this.configuration.getCacheFileName());
            BufferedInputStream bis = new BufferedInputStream(fis);
            ObjectInputStream ois = new ObjectInputStream(bis);
            ConcurrentHashMap cached = (ConcurrentHashMap)ois.readObject();
            ois.close();
            bis.close();
            fis.close();
            Logger.d("FSCache Cached size: " + cached.size());
            this.internalCache.putAll(cached);
            timings.addSplit("Read file");
            timings.dumpToLog();
        }
        catch (FileNotFoundException e) {
            Logger.d("FSCache Cache file not found!");
            return;
        }
        catch (IOException e) {
            Logger.e("FSCache Error when try to deserialize cache: ", e);
        }
        catch (ClassNotFoundException e) {
            Logger.e("FSCache Error when try to deserialize cache: ", e);
        }
    }

    public void clear() {
        this.internalCache.clear();
        this.clearBuffers();
        File cache = new File(this.context.getFilesDir(), this.configuration.getCacheFileName());
        if (!cache.exists()) {
            return;
        }
        cache.delete();
        Logger.d("FSCache Cache file deleted");
    }

    public synchronized void clearBuffers() {
        this.ignored.clear();
        this.iBeaconIdResolver.clear();
        this.eddystoneUIDResolver.clear();
        Logger.d("FSCacheCleared internal buffers");
    }

    public void markIgnored(RemoteBluetoothDevice beacon) {
        switch (beacon.getProfile()) {
            case IBEACON: {
                this.iBeaconIdResolver.markIgnored(beacon);
                break;
            }
            case EDDYSTONE: {
                this.eddystoneUIDResolver.markIgnored(beacon);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported device profile!");
            }
        }
    }

    private class DeserializerThread
    extends Thread {
        DeserializerThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            FutureShufflesCache.this.deserialize();
            FutureShufflesCache.this.state = CacheState.INITIALIZED;
        }
    }

    private static enum CacheState {
        INITIALIZING,
        INITIALIZED;

    }
}

