/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.cache;

import com.kontakt.sdk.android.ble.cache.EddystoneResolveRequest;
import com.kontakt.sdk.android.ble.cache.EddystoneResolveStrategy;
import com.kontakt.sdk.android.ble.cache.ResolveRequestStatus;
import com.kontakt.sdk.android.ble.cache.ResolverType;
import com.kontakt.sdk.android.cloud.IKontaktCloud;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.paginated.Devices;
import com.kontakt.sdk.android.common.model.Device;
import com.kontakt.sdk.android.common.model.EddystoneFutureUID;
import com.kontakt.sdk.android.common.model.EddystoneUid;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class EddystoneApiResolveStrategy
implements EddystoneResolveStrategy {
    private final IKontaktCloud kontaktCloud;

    EddystoneApiResolveStrategy(IKontaktCloud kontaktCloud) {
        this.kontaktCloud = kontaktCloud;
    }

    @Override
    public List<EddystoneFutureUID> resolve(Map<EddystoneUid, EddystoneResolveRequest> requests) throws Exception {
        List<EddystoneUid> toResolve = this.eddystonesToResolve(requests);
        if (toResolve.isEmpty()) {
            return Collections.emptyList();
        }
        List<EddystoneFutureUID> futureIds = this.resolveEddystones(toResolve);
        this.updateRequests(requests, futureIds);
        return futureIds;
    }

    private List<EddystoneUid> eddystonesToResolve(Map<EddystoneUid, EddystoneResolveRequest> requests) {
        ArrayList<EddystoneUid> toResolve = new ArrayList<EddystoneUid>();
        for (Map.Entry<EddystoneUid, EddystoneResolveRequest> entry : requests.entrySet()) {
            EddystoneResolveRequest request = entry.getValue();
            if (ResolveRequestStatus.RESOLVED == request.getStatus()) continue;
            toResolve.add(entry.getKey());
        }
        return toResolve;
    }

    private List<EddystoneFutureUID> resolveEddystones(List<EddystoneUid> uids) throws IOException, KontaktCloudException {
        Devices cloudResult = (Devices)this.kontaktCloud.devices().eddystones().withIds(uids).execute();
        Object devices = cloudResult.getContent();
        ArrayList<EddystoneFutureUID> futureIds = new ArrayList<EddystoneFutureUID>();
        Iterator iterator = devices.iterator();
        while (iterator.hasNext()) {
            Device device = (Device)iterator.next();
            EddystoneFutureUID eddystoneFutureUID = device.extractEddystoneFutureUID();
            if (eddystoneFutureUID == null) continue;
            futureIds.add(eddystoneFutureUID);
        }
        return futureIds;
    }

    private void updateRequests(Map<EddystoneUid, EddystoneResolveRequest> requests, List<EddystoneFutureUID> futureIds) {
        for (EddystoneFutureUID id : futureIds) {
            this.updateRequest(requests, id);
        }
    }

    private void updateRequest(Map<EddystoneUid, EddystoneResolveRequest> requests, EddystoneFutureUID id) {
        EddystoneResolveRequest request = requests.get(id.getQueriedBy());
        request.setResolvedBy(ResolverType.API);
        if (ResolveRequestStatus.IGNORED == request.getStatus()) {
            return;
        }
        request.setStatus(ResolveRequestStatus.RESOLVED);
    }
}

