/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.Access;
import com.kontakt.sdk.android.common.model.Device;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class Venue
implements Parcelable {
    public static final Parcelable.Creator<Venue> CREATOR = new Parcelable.Creator<Venue>(){

        public Venue createFromParcel(Parcel source) {
            return new Venue(source);
        }

        public Venue[] newArray(int size) {
            return new Venue[size];
        }
    };
    private UUID id;
    private String name;
    private String description;
    private int devicesCount;
    private List<Device> devices;
    private String coverType;
    private String image;
    private UUID managerId;
    private Access access;
    private String lng;
    private String lat;

    public static Builder builder() {
        return new Builder();
    }

    private Venue() {
        this(new Builder());
    }

    private Venue(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.devicesCount = builder.devicesCount;
        this.devices = builder.devices;
        this.coverType = builder.coverType;
        this.image = builder.imageUrl;
        this.managerId = builder.managerId;
        this.lng = builder.lng;
        this.lat = builder.lat;
        this.access = builder.access;
    }

    protected Venue(Parcel in) {
        this.id = (UUID)in.readSerializable();
        this.name = in.readString();
        this.description = in.readString();
        this.devicesCount = in.readInt();
        this.devices = in.createTypedArrayList(Device.CREATOR);
        this.coverType = in.readString();
        this.image = in.readString();
        this.managerId = (UUID)in.readSerializable();
        int tmpAccess = in.readInt();
        this.access = tmpAccess == -1 ? null : Access.values()[tmpAccess];
        this.lng = in.readString();
        this.lat = in.readString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Venue)) {
            return false;
        }
        Venue venue = (Venue)o;
        return SDKEqualsBuilder.start().equals(this.id, venue.id).equals(this.name, venue.name).equals(this.description, venue.description).equals(this.coverType, venue.coverType).equals(this.devicesCount, venue.devicesCount).equals(this.image, venue.image).equals(this.devices, venue.devices).equals(this.managerId, venue.managerId).equals(this.lat, venue.lat).equals(this.lng, venue.lng).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.id).append(this.name).append(this.description).append(this.coverType).append(this.devicesCount).append(this.image).append(this.devices).append(this.managerId).append(this.lat).append(this.lng).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.id);
        dest.writeString(this.name);
        dest.writeString(this.description);
        dest.writeInt(this.devicesCount);
        dest.writeTypedList(this.devices);
        dest.writeString(this.coverType);
        dest.writeString(this.image);
        dest.writeSerializable((Serializable)this.managerId);
        dest.writeInt(this.access == null ? -1 : this.access.ordinal());
        dest.writeString(this.lng);
        dest.writeString(this.lat);
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getDevicesCount() {
        return this.devicesCount;
    }

    public String getCoverType() {
        return this.coverType;
    }

    public String getImageUrl() {
        return this.image;
    }

    public UUID getManagerId() {
        return this.managerId;
    }

    public List<Device> getDevices() {
        return this.devices;
    }

    public Access getAccess() {
        return this.access;
    }

    public String getLongitude() {
        return this.lng;
    }

    public String getLatitude() {
        return this.lat;
    }

    public static class Builder {
        private UUID id;
        private String name;
        private String description;
        private int devicesCount;
        private List<Device> devices = new ArrayList<Device>();
        private String coverType;
        private String imageUrl;
        private UUID managerId;
        private String lng;
        private String lat;
        private Access access;

        public Builder id(UUID id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder devicesCount(int devicesCount) {
            SDKPreconditions.checkState(devicesCount >= 0, "devices count cannot be negative");
            this.devicesCount = devicesCount;
            return this;
        }

        public Builder addDevices(Collection<Device> devices) {
            SDKPreconditions.checkNotNull(devices, "devices cannot be null");
            for (Device device : devices) {
                SDKPreconditions.checkNotNull(device, "devices cannot contain null value");
            }
            this.devices.addAll(devices);
            return this;
        }

        public Builder addDevice(Device device) {
            SDKPreconditions.checkNotNull(device, "device cannot be null");
            this.devices.add(device);
            return this;
        }

        public Builder coverType(String coverType) {
            this.coverType = coverType;
            return this;
        }

        public Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder managerId(UUID managerId) {
            this.managerId = managerId;
            return this;
        }

        public Builder longitude(String lng) {
            this.lng = lng;
            return this;
        }

        public Builder latitude(String lat) {
            this.lat = lat;
            return this;
        }

        public Builder access(Access access) {
            this.access = access;
            return this;
        }

        public Venue build() {
            return new Venue(this);
        }
    }
}

