/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.UUID;

public class ProximityId
implements Parcelable {
    public static final Parcelable.Creator<ProximityId> CREATOR = new Parcelable.Creator<ProximityId>(){

        public ProximityId createFromParcel(Parcel source) {
            return new ProximityId(source);
        }

        public ProximityId[] newArray(int size) {
            return new ProximityId[size];
        }
    };
    @SerializedName(value="proximity")
    private UUID proximityUUID;
    @SerializedName(value="secureProximity")
    private UUID secureProximityUUID;
    private boolean shuffled;
    private boolean shared;

    public static Builder builder() {
        return new Builder();
    }

    private ProximityId() {
        this(new Builder());
    }

    private ProximityId(Builder builder) {
        this.proximityUUID = builder.proximityUUID;
        this.secureProximityUUID = builder.secureProximityUUID;
        this.shuffled = builder.shuffled;
        this.shared = builder.shared;
    }

    protected ProximityId(Parcel in) {
        this.proximityUUID = (UUID)in.readSerializable();
        this.secureProximityUUID = (UUID)in.readSerializable();
        this.shuffled = in.readByte() != 0;
        this.shared = in.readByte() != 0;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ProximityId)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ProximityId other = (ProximityId)o;
        return SDKEqualsBuilder.start().equals(this.proximityUUID, other.proximityUUID).equals(this.secureProximityUUID, other.secureProximityUUID).equals(this.shuffled, other.shuffled).equals(this.shared, other.shared).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.proximityUUID).append(this.secureProximityUUID).append(this.shuffled).append(this.shared).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.proximityUUID);
        dest.writeSerializable((Serializable)this.secureProximityUUID);
        dest.writeByte(this.shuffled ? (byte)1 : 0);
        dest.writeByte(this.shared ? (byte)1 : 0);
    }

    public UUID getProximityUUID() {
        return this.proximityUUID;
    }

    public UUID getSecureProximityUUID() {
        if (this.proximityUUID.equals(this.secureProximityUUID)) {
            return null;
        }
        return this.secureProximityUUID;
    }

    public boolean isShuffled() {
        return this.shuffled;
    }

    public boolean isShared() {
        return this.shared;
    }

    public static class Builder {
        private UUID proximityUUID;
        private UUID secureProximityUUID;
        private boolean shuffled;
        private boolean shared;

        public Builder proximity(UUID proximityUUID) {
            this.proximityUUID = proximityUUID;
            return this;
        }

        public Builder secureProximity(UUID secureProximityUUID) {
            this.secureProximityUUID = secureProximityUUID;
            return this;
        }

        public Builder shuffled(boolean shuffled) {
            this.shuffled = shuffled;
            return this;
        }

        public Builder shared(boolean shared) {
            this.shared = shared;
            return this;
        }

        public ProximityId build() {
            return new ProximityId(this);
        }
    }
}

