/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.Serializable;
import java.util.UUID;

public class Preset
implements Parcelable {
    public static final Parcelable.Creator<Preset> CREATOR = new Parcelable.Creator<Preset>(){

        public Preset createFromParcel(Parcel source) {
            return new Preset(source);
        }

        public Preset[] newArray(int size) {
            return new Preset[size];
        }
    };
    public static final int INTERVAL_MIN_VALUE = 20;
    public static final int INTERVAL_MAX_VALUE = 10240;
    public static final int TX_POWER_MIN_VALUE = 0;
    public static final int TX_POWER_MAX_VALUE = 7;
    private UUID proximity;
    private int interval;
    private int txPower;
    private String name;
    private String description;

    public static Builder builder() {
        return new Builder();
    }

    private Preset() {
        this(new Builder());
    }

    private Preset(Builder builder) {
        this.proximity = builder.proximity;
        this.interval = builder.interval;
        this.txPower = builder.txPower;
        this.name = builder.name;
        this.description = builder.description;
    }

    protected Preset(Parcel in) {
        this.proximity = (UUID)in.readSerializable();
        this.interval = in.readInt();
        this.txPower = in.readInt();
        this.name = in.readString();
        this.description = in.readString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Preset)) {
            return false;
        }
        Preset profile = (Preset)obj;
        return SDKEqualsBuilder.start().equals(this.proximity, profile.proximity).equals(this.interval, profile.interval).equals(this.txPower, profile.txPower).equals(this.name, profile.name).equals(this.description, profile.description).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.proximity).append(this.interval).append(this.txPower).append(this.name).append(this.description).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.proximity);
        dest.writeInt(this.interval);
        dest.writeInt(this.txPower);
        dest.writeString(this.name);
        dest.writeString(this.description);
    }

    public UUID getProximity() {
        return this.proximity;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getTxPower() {
        return this.txPower;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public static class Builder {
        private UUID proximity;
        private int interval = 0;
        private int txPower = -1;
        private String name;
        private String description;

        public Builder proximity(UUID proximity) {
            this.proximity = proximity;
            return this;
        }

        public Builder interval(int interval) {
            SDKPreconditions.checkState(interval >= 20 && interval <= 10240, "interval should be in range from 20 to 10240");
            this.interval = interval;
            return this;
        }

        public Builder txPower(int txPower) {
            SDKPreconditions.checkState(txPower >= 0 && txPower <= 7, "txPower should be in range from 0 to 7");
            this.txPower = txPower;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Preset build() {
            return new Preset(this);
        }
    }
}

