/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.IBeaconId;
import com.kontakt.sdk.android.common.model.IFutureId;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.List;

public class IBeaconFutureId
implements IFutureId<IBeaconId> {
    public static final Parcelable.Creator<IBeaconFutureId> CREATOR = new Parcelable.Creator<IBeaconFutureId>(){

        public IBeaconFutureId createFromParcel(Parcel source) {
            return new IBeaconFutureId(source);
        }

        public IBeaconFutureId[] newArray(int size) {
            return new IBeaconFutureId[size];
        }
    };
    private String uniqueId;
    private IBeaconId queriedBy;
    private IBeaconId resolved;
    private List<IBeaconId> futureIds;

    public static Builder builder() {
        return new Builder();
    }

    private IBeaconFutureId(Builder builder) {
        this.uniqueId = builder.uniqueId;
        this.queriedBy = builder.queriedBy;
        this.resolved = builder.resolved;
        this.futureIds = builder.futureIds;
    }

    protected IBeaconFutureId(Parcel in) {
        this.uniqueId = in.readString();
        this.queriedBy = (IBeaconId)in.readParcelable(IBeaconId.class.getClassLoader());
        this.resolved = (IBeaconId)in.readParcelable(IBeaconId.class.getClassLoader());
        this.futureIds = in.createTypedArrayList(IBeaconId.CREATOR);
    }

    @Override
    public IBeaconId getQueriedBy() {
        return this.queriedBy;
    }

    @Override
    public IBeaconId getResolved() {
        return this.resolved;
    }

    @Override
    public List<IBeaconId> getFutureIds() {
        return this.futureIds;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof IBeaconFutureId)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        IBeaconFutureId other = (IBeaconFutureId)o;
        return SDKEqualsBuilder.start().equals(this.resolved, other.resolved).equals(this.queriedBy, other.queriedBy).equals(this.futureIds, other.futureIds).equals(this.uniqueId, other.uniqueId).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.resolved).append(this.queriedBy).append(this.futureIds).append(this.uniqueId).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.uniqueId);
        dest.writeParcelable((Parcelable)this.queriedBy, flags);
        dest.writeParcelable((Parcelable)this.resolved, flags);
        dest.writeTypedList(this.futureIds);
    }

    public static class Builder {
        private String uniqueId;
        private IBeaconId queriedBy;
        private IBeaconId resolved;
        private List<IBeaconId> futureIds = new ArrayList<IBeaconId>();

        public Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public Builder queriedBy(IBeaconId queriedBy) {
            this.queriedBy = queriedBy;
            return this;
        }

        public Builder resolved(IBeaconId resolved) {
            this.resolved = resolved;
            return this;
        }

        public Builder futureIds(List<IBeaconId> futureIds) {
            SDKPreconditions.checkNotNull(futureIds, "future IDs cannot be null");
            this.futureIds.clear();
            this.futureIds.addAll(futureIds);
            return this;
        }

        public IBeaconFutureId build() {
            return new IBeaconFutureId(this);
        }
    }
}

