/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.kontakt.sdk.android.common.model.PacketType;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.EddystoneUtils;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class Config
implements Parcelable {
    public static final Parcelable.Creator<Config> CREATOR = new Parcelable.Creator<Config>(){

        public Config createFromParcel(Parcel source) {
            return new Config(source);
        }

        public Config[] newArray(int size) {
            return new Config[size];
        }
    };
    public static final int INTERVAL_MIN_VALUE = 20;
    public static final int INTERVAL_MAX_VALUE = 10240;
    public static final int TX_POWER_MIN_VALUE = 0;
    public static final int TX_POWER_MAX_VALUE = 7;
    private String uniqueId;
    private UUID proximity;
    private int major = -1;
    private int minor = -1;
    private int txPower = -1;
    private int interval = -1;
    private String namespace;
    private String url;
    private String instanceId;
    private List<DeviceProfile> profiles;
    private List<PacketType> packets;
    private Boolean shuffled;
    private String name;
    private String password;
    @SerializedName(value="config")
    private String secureRequest;
    private String secureResponse;
    private long secureResponseTime;

    public static Builder builder() {
        return new Builder();
    }

    private Config() {
        this(new Builder());
    }

    private Config(Builder builder) {
        this.uniqueId = builder.uniqueId;
        this.interval = builder.interval;
        this.txPower = builder.txPower;
        this.instanceId = builder.instanceId;
        this.url = builder.url;
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.proximity = builder.proximity;
        this.major = builder.major;
        this.minor = builder.minor;
        this.profiles = builder.profiles;
        this.packets = builder.packets;
        this.shuffled = builder.shuffled;
        this.password = builder.password;
        this.secureRequest = builder.secureRequest;
        this.secureResponse = builder.secureResponse;
        this.secureResponseTime = builder.secureResponseTime;
    }

    protected Config(Parcel in) {
        this.uniqueId = in.readString();
        this.proximity = (UUID)in.readSerializable();
        this.major = in.readInt();
        this.minor = in.readInt();
        this.txPower = in.readInt();
        this.interval = in.readInt();
        this.namespace = in.readString();
        this.url = in.readString();
        this.instanceId = in.readString();
        this.profiles = new ArrayList<DeviceProfile>();
        in.readList(this.profiles, DeviceProfile.class.getClassLoader());
        this.packets = new ArrayList<PacketType>();
        in.readList(this.packets, PacketType.class.getClassLoader());
        this.shuffled = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.name = in.readString();
        this.password = in.readString();
        this.secureRequest = in.readString();
        this.secureResponse = in.readString();
        this.secureResponseTime = in.readLong();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Config)) {
            return false;
        }
        Config config = (Config)object;
        return SDKEqualsBuilder.start().equals(this.uniqueId, config.uniqueId).equals(this.proximity, config.proximity).equals(this.major, config.major).equals(this.minor, config.minor).equals(this.txPower, config.txPower).equals(this.interval, config.interval).equals(this.namespace, config.namespace).equals(this.url, config.url).equals(this.instanceId, config.instanceId).equals(this.name, config.name).equals(this.password, config.password).equals(this.profiles, config.profiles).equals(this.packets, config.packets).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.uniqueId).append(this.proximity).append(this.major).append(this.minor).append(this.txPower).append(this.interval).append(this.namespace).append(this.url).append(this.instanceId).append(this.shuffled).append(this.name).append(this.password).append(this.profiles).append(this.packets).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.uniqueId);
        dest.writeSerializable((Serializable)this.proximity);
        dest.writeInt(this.major);
        dest.writeInt(this.minor);
        dest.writeInt(this.txPower);
        dest.writeInt(this.interval);
        dest.writeString(this.namespace);
        dest.writeString(this.url);
        dest.writeString(this.instanceId);
        dest.writeList(this.profiles);
        dest.writeList(this.packets);
        dest.writeValue((Object)this.shuffled);
        dest.writeString(this.name);
        dest.writeString(this.password);
        dest.writeString(this.secureRequest);
        dest.writeString(this.secureResponse);
        dest.writeLong(this.secureResponseTime);
    }

    void applyConfig(Config config) {
        SDKPreconditions.checkNotNull(config, "config data cannot be null");
        if (config.interval != -1) {
            this.interval = config.interval;
        }
        if (config.txPower != -1) {
            this.txPower = config.txPower;
        }
        if (config.instanceId != null) {
            this.instanceId = config.instanceId;
        }
        if (config.url != null) {
            this.url = config.url;
        }
        if (config.namespace != null) {
            this.namespace = config.namespace;
        }
        if (config.name != null) {
            this.name = config.name;
        }
        if (config.proximity != null) {
            this.proximity = config.proximity;
        }
        if (config.major != -1) {
            this.major = config.major;
        }
        if (config.minor != -1) {
            this.minor = config.minor;
        }
        if (config.profiles != null) {
            this.profiles = config.profiles;
        }
        if (config.packets != null) {
            this.packets = config.packets;
        }
        if (config.shuffled != null) {
            this.shuffled = config.shuffled;
        }
        if (config.password != null) {
            this.password = config.password;
        }
    }

    void applySecureConfig(Config secureConfig) {
        SDKPreconditions.checkNotNull(secureConfig, "secure config data cannot be null");
        SDKPreconditions.checkNotNull(secureConfig.getSecureRequest(), "secure config cannot be null");
        SDKPreconditions.checkNotNull(secureConfig.getSecureResponse(), "secure response cannot be null");
        this.secureRequest = secureConfig.secureRequest;
        this.secureResponse = secureConfig.secureResponse;
        this.secureResponseTime = secureConfig.secureResponseTime;
    }

    public void applySecureRequest(String secureRequest) {
        SDKPreconditions.checkNotNullOrEmpty(secureRequest, "secure request cannot be either null or empty");
        this.secureRequest = secureRequest;
    }

    public void applySecureResponse(String secureResponse, long secureResponseTime) {
        SDKPreconditions.checkNotNull(secureResponse, "secure response cannot be null");
        SDKPreconditions.checkState(secureResponseTime > 0L, "secure response timestamp cannot be negative");
        this.secureResponse = secureResponse;
        this.secureResponseTime = secureResponseTime;
    }

    public void changePassword(String password) {
        this.password = password;
    }

    public boolean isSecureConfig() {
        return this.secureRequest != null && !"".equals(this.secureRequest);
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public UUID getProximity() {
        return this.proximity;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getTxPower() {
        return this.txPower;
    }

    public int getInterval() {
        return this.interval;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getHexUrl() {
        if (this.url != null) {
            return EddystoneUtils.toHexString(EddystoneUtils.serializeUrl(this.url));
        }
        return null;
    }

    public String getUrl() {
        return this.url;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public List<DeviceProfile> getProfiles() {
        if (this.profiles != null) {
            return Collections.unmodifiableList(this.profiles);
        }
        return null;
    }

    public List<PacketType> getPackets() {
        if (this.packets != null) {
            return Collections.unmodifiableList(this.packets);
        }
        return null;
    }

    public Boolean getShuffled() {
        return this.shuffled;
    }

    public boolean isShuffled() {
        if (this.shuffled == null) {
            return false;
        }
        return this.shuffled;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSecureRequest() {
        return this.secureRequest;
    }

    public String getSecureResponse() {
        return this.secureResponse;
    }

    public long getSecureResponseTime() {
        return this.secureResponseTime;
    }

    public static class Builder {
        private String uniqueId;
        private int interval = -1;
        private int txPower = -1;
        private String instanceId;
        private String url;
        private String namespace;
        private String name;
        private UUID proximity;
        private int major = -1;
        private int minor = -1;
        private List<DeviceProfile> profiles = new ArrayList<DeviceProfile>();
        private List<PacketType> packets = new ArrayList<PacketType>();
        private Boolean shuffled;
        private String password;
        private String secureRequest;
        private String secureResponse;
        private long secureResponseTime;

        public Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public Builder interval(int interval) {
            SDKPreconditions.checkState(interval >= 20 && interval <= 10240, "interval should be in range from 20 to 10240");
            this.interval = interval;
            return this;
        }

        public Builder txPower(int txPower) {
            SDKPreconditions.checkState(txPower >= 0 && txPower <= 7, "txPower should be in range from 0 to 7");
            this.txPower = txPower;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder url(String url) {
            boolean isHexUrl;
            this.url = url != null ? ((isHexUrl = EddystoneUtils.isStringOnlyHex(url)) ? EddystoneUtils.fromHexedUrlToUrl(url) : url) : null;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder proximity(UUID proximity) {
            this.proximity = proximity;
            return this;
        }

        public Builder major(int major) {
            SDKPreconditions.checkState(major >= 0, "major cannot be negative");
            this.major = major;
            return this;
        }

        public Builder minor(int minor) {
            SDKPreconditions.checkState(minor >= 0, "minor cannot be negative");
            this.minor = minor;
            return this;
        }

        public Builder profiles(Collection<DeviceProfile> profiles) {
            SDKPreconditions.checkNotNull(profiles, "profiles cannot be null");
            for (DeviceProfile profile : profiles) {
                SDKPreconditions.checkNotNull(profile, "profiles cannot contain null value");
            }
            this.profiles.clear();
            for (DeviceProfile profile : profiles) {
                if (this.profiles.contains((Object)profile)) continue;
                this.profiles.add(profile);
            }
            return this;
        }

        public Builder packets(Collection<PacketType> packets) {
            SDKPreconditions.checkNotNull(packets, "packets cannot be null");
            for (PacketType packet : packets) {
                SDKPreconditions.checkNotNull(packet, "packets cannot contain null value");
            }
            this.packets.clear();
            for (PacketType packet : packets) {
                if (this.packets.contains((Object)packet)) continue;
                this.packets.add(packet);
            }
            return this;
        }

        public Builder shuffled(boolean shuffled) {
            this.shuffled = shuffled;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder secureRequest(String secureRequest) {
            this.secureRequest = secureRequest;
            return this;
        }

        public Builder secureResponse(String secureResponse) {
            this.secureResponse = secureResponse;
            return this;
        }

        public Builder secureResponseTime(long secureResponseTime) {
            SDKPreconditions.checkState(secureResponseTime >= 0L, "secure response time cannot be negative");
            this.secureResponseTime = secureResponseTime;
            return this;
        }

        public Config build() {
            if (this.packets.size() == 0) {
                if (this.profiles.contains((Object)DeviceProfile.IBEACON)) {
                    this.packets.add(PacketType.IBEACON);
                }
                if (this.profiles.contains((Object)DeviceProfile.EDDYSTONE)) {
                    this.packets.add(PacketType.EDDYSTONE_UID);
                    this.packets.add(PacketType.EDDYSTONE_URL);
                    this.packets.add(PacketType.EDDYSTONE_TLM);
                }
            }
            return new Config(this);
        }
    }
}

